#
| Object is coloured by use of distance from the lightsources
#

#
| Define the position of the lightsources
| The first three parameters describe the coordinates
| the fourth parameter describes the Helligkeitsverlust.
#

RED   := [ 2,  2,  1, 1.0]:
GREEN := [ 0,  0,  1, 1.0]:
BLUE  := [-2, -2,  1, 1.0]:

light := proc(x, y, z, light_source)
local dist, erg;
begin
    dist := sqrt((x-op(light_source, 1))^2+
                 (y-op(light_source, 2))^2 + 
                 (z-op(light_source, 3))^2):
    if dist >= 0 and dist <= 1 then
        erg := op(light_source, 4):
    else
        erg  := op(light_source, 4)/dist:
    end_if:    
    if erg < 0.0 then 
        erg := 0.0: 
    end_if:
    erg:
end_proc:

cfun_surf_3d := proc(x_coord, y_coord, z_coord, u_val, v_val)
local red, green, blue;
begin
    #
    | Calculate the distance (x, y, z) <-> light_source.
    #
    red   := light(x_coord, y_coord, z_coord, RED):
    green := light(x_coord, y_coord, z_coord, GREEN):
    blue  := light(x_coord, y_coord, z_coord, BLUE):
  
    [red, green, blue]:
end_proc:

plot3d(CameraPoint = [-8, -7, 8],
       [Mode = Surface,
             [u, v, 0], u =[-2,2], v=[-2,2],
             Color=[Function, cfun_surf_3d],
             Style = [ColorPatches, AndMesh],
             Grid = [30, 30]
       ]);
