#
| sphere coloured by use of colorfunction
#

UGRID  :=         21:
UMIN   := float(-PI):
UMAX   :=  float(PI):
DELTAU := (UMIN-UMAX)/UGRID:
ZMIN   := -1.0:
ZMAX   :=  1.0:

colfun_3d := proc(x_coord, y_coord, z_coord, u_val, v_val)
local ugrid, zvalue;
begin
    ugrid  := round((v_val - UMIN + 0.5*DELTAU)/DELTAU):
    zvalue := (z_coord - ZMIN)/(ZMAX - ZMIN):
    if  ugrid mod 2 = 0 then
        [zvalue, 0, 0.5]:
    else
        [0, 1-zvalue, 0.5]:
    end_if:
end_proc:

plot3d(Axes = None,
            [Mode = Surface,
                  [sin(u)*cos(v), sin(u)*sin(v),
                   cos(u)], u = [0, PI], v = [-PI, PI],
                  Color = [Function, colfun_3d],
                  Grid = [21, 21],
                  Style = [ColorPatches, AndMesh]
            ]);
