#
| This file contains the definition of the three
| procedures riem_x(), riem_y() and riem_z(), des-
| cribing the coordinates of the Riemann sphere.
| I.e. these are parametrizations of the so called
| stereographic projection, projecting a point of
| the complex plane on to the Riemann sphere.
|
| At the end of this file an example plot command
| has been added.
|
| Author: T.S.
#

riem_x := proc(u,v)
begin
  2/(1+abs(u+I*v)^2)*u:
end_proc:

riem_y := proc(u,v)
begin
  2/(1+abs(u+I*v)^2)*v:
end_proc:

riem_z := proc(u,v)
begin
  1/(1+abs(u+I*v)^2)*(abs(u+I*v)^2-1)
end_proc:


#
| example plot command
|
| Change the ranges for u and v and you will
| see the evolution of the Riemann sphere.
| Furthermore the northpole of this sphere
| will never been reached.
#

 plot3d(Axes = None,
        [Mode = Surface,
              [hold(riem_x(u,v)),
               hold(riem_y(u,v)),
               hold(riem_z(u,v))],
              u = [-PI, PI], v =[-PI, PI], 
              Grid = [30,30], Style = [ColorPatches, AndMesh]]);


