#
 
These examples are taken from:
Ralf Schaper, Grafik mit Mathematica, pp. 145-148, Addison-Wesley, 1994

#

rc1:=proc(ug, og, m, k)
  local n, t;
begin
  plot2d(Axes = None, 
         [ Mode=Curve, 
           [ _plus( sin(n^2*t)/(n^2) $ n = 1..m),
             _plus( cos(n^2*t)/(n^2) $ n = 1..m) 
           ],
           t = [ug, og], Grid = [k]
         ]
  );
end_proc:

rc2:=proc(ug, og, m, k)
  local n, t;
begin
  plot2d(Axes = None, 
         [ Mode=Curve,
           [ _plus( sin((-1)^n*n^2*t)/((-1)^n*n^2) $ n = 1..m),
             _plus( cos((-1)^n*n^2*t)/((-1)^n*n^2) $ n = 1..m)
           ],
           t = [ug, og], Grid = [k]
         ]
  );
end_proc:


rc1(0      , 2*PI    ,  10, 500);
rc2(0      , 2*PI    ,  10, 500);

#
rc1(0      , 2*PI    , 100, 500);
rc1(0.2    , PI/2-0.1, 100, 500);
rc1(PI-0.5 , PI+0.5  , 100, 500);
rc2(0      , 2*PI    ,   2, 100);
rc2(0      , 2*PI    ,   3, 100);
rc2(0      , 2*PI    ,   5, 100);
rc2(0      , 2*PI    ,  20, 500);
rc2(0      , 2*PI    ,  50, 500);
rc2(PI-0.5 , PI+0.5  ,  50, 500);
#       
