#
| another pointlist
#

cube_rec := proc(hexagon, delta, n)
local i;
begin
    if n = 0 then
        polygon(op(hexagon), op(hexagon, 1)):
    else
        for i from 1 to nops(hexagon) do
           newx := op(hexagon, [i,1]) + 
                   delta*(op(hexagon, [(i mod 6) + 1, 1])
                        - op(hexagon, [i,1])):
           newy := op(hexagon, [i,2]) + 
                   delta*(op(hexagon, [(i mod 6) + 1, 2])
                        - op(hexagon, [i,2])):
           if i = 1 then 
               new_hexagon := [point(newx, newy)]:
           else
               new_hexagon := append(new_hexagon, point(newx, newy)):
           end_if:
        end_for:
        polygon(op(hexagon), op(hexagon, 1)),
        cube_rec(new_hexagon, delta, n-1):
    end_if:
end_proc:

root     := 0.5*sqrt(3.0):
hexagon1 := [point(1, 0),
             point(0.5, root),
             point(-0.5, root),
             point(-1, 0),
             point(-0.5, -root), 
             point(0.5, -root)]:

hexagon2 := [point(2.5, root), 
             point(2.0, 2*root),
             point(1.0, 2*root), 
             point(0.5, root),
             point(1.0, 0), 
             point(2.0, 0)]:

hexagon3 := [point(2.5, -root),
             point(2.0, 0),
             point(1.0, 0),
             point(0.5, -root),
             point(1.0, -2*root), 
             point(2.0, -2*root)]:

hexagon4 := [point(4, 0),
             point(3.5, root),
             point(2.5, root),
             point(2, 0),
             point(2.5, -root), 
             point(3.5, -root)]:

plot2d(Axes = None,
            [Mode = List, [cube_rec(hexagon1, 0.2, 30)],
            Color = [Height]],
            [Mode = List, [cube_rec(hexagon2, 0.2, 30)],
            Color = [Height]],
            [Mode = List, [cube_rec(hexagon3, 0.2, 30)],
            Color = [Height]],
            [Mode = List, [cube_rec(hexagon4, 0.2, 30)],
            Color = [Height]]);
