# 
| This file contains the definition of the procedure
| burg_one(), describing the single soliton solution
| of the so called Burgers equation.
| 
| The parameter c determines the asymptotic velocity
| of the single wave.
| 
| At the end of this file an example plot command has
| been added.
| 
| Author: T.S.
#

burg_one := proc(x, t, c)
begin

  c + c*tanh(c*x + 2*c^2*t):

end_proc:

#
| example plot command
#

plot3d(Axes = None, 
       [Mode = Surface, 
             [u, v, hold(burg_one(u,v,1))],
             u = [-10, 10], v = [-10, 10],
             Grid = [30, 30]]);
  
