#
| This file contains the definition of the procedure
| kdv_one(), describing the single soliton solution
| of the so called Korteweg-de Vries equation.
| The third parameter c of this function describes the
| asymptotic velocity of the single wave.
|
| At the end of this file an example plot command
| has been added.
| 
| Author: T.S.
#

kdv_one := proc(x, t, c)

local e1, f, fx, fxx;

begin
  e1  := exp(c*x - c^3*t):
  f   := 1     + e1:
  fx  :=       c*e1:
  fxx :=     c^2*e1:

  (fxx*f - fx^2)/f^2:
end_proc:


# 
| example plot command    
|
| Change the third parameter of the procedure
| kdv_one() to plot solitons with different
| velocities.
#

 plot3d(Axes = Box, Ticks = 0,
        [Mode = Surface,
              [u, v, hold(10*kdv_one(u,1/2*v,1))],
              u = [-10, 10], v = [-10, 10], Grid = [30, 30],
              Style = [ColorPatches, AndMesh],
              Color = [Height, [0,0, 65335],[0,65335,65335]]]);

                   
