#
| This file contains the definition of the 
| procedure sg_two, describing the two so-
| liton solution of the so called Sine-Gor-
| don equation.
| The third and fourth parameters describe
| the asymptotic velocities of the two in-
| teracting waves.
|
| At the end of this file an example plot
| command has been added.
| 
| Author: T.S.
#

sg_two := proc(x, t, c1, c2)

local e1, e2, e12, f, g;

begin

  e1   := exp(c1*x - 1/c1*t):
  e2   := exp(c2*x - 1/c2*t):
  e12  := e1*e2:

  f    := (c1-c2)*(1 + e12):
  g    := (c1+c2)*(e1 - e2):

  4*atan(g/f):

end_proc:

#
| example plot command,
| To get a Kink-Kink-Solution take -9/10 instead of 9/10.
# 

 plot3d(Axes = Box, Scaling = UnConstrained, Ticks = 0,
        CameraPoint = [-45, -90, 60],
        [Mode = Surface,
              [u, v, hold(sg_two(u, v, 3/2, 9/10))],
              u = [-25, 25], v = [-30, 30], Grid = [40, 40],
              Style = [ColorPatches, AndMesh],
              Color = [Height, [0,0,65335],[65335,0,65335]]]);

