# 23.1.94, kamo#
#++
 powerset(n) - powerset of a set

If n is an integer, then powerset(n) returns a set with all subsets of
{1,...,n}.  If n is a set, a set of all subsets of n is returned.
++#
combinat::powerset:= proc(n)
        local set, subset;
        begin
        subset := proc(set)
        local elem, result;
        begin
		case nops(set) 
		   of 0 do 
			return({{}});
		   of 1 do
			return({set,{}});
		   of 2 do 
                        return({{op(set,1),op(set,2)},{op(set,2)},{op(set,1)},{}});
                end_case;
                elem := op(set,1);
                result := subset(subs(set, elem = null()));
                result := result union map(result, _union, {elem});
        end_proc;

        if testtype(n,DOM_INT) then
                if n < 0 then
                        error("argument must be a set or a non-negative integer!");
                end_if;
                case n
                        of 0 do return({{}}); break;
                        of 1 do return({{},{1}}); break;
                        otherwise set := {$1..n};
                end_case;
        else
                set := n;
        end_if;

        if not testtype(set,DOM_SET) then
                error("argument must be a set or a non-negative integer!");
        end_if;
        if args(0) <> 1 then
                error("wrong number of arguments !");
        end_if;

        subset(set);
end_proc:
