#
stirling1 -- Stirling numbers of the first kind

Calling Sequence:
 
   stirling1(n, m)
 
Parameters:
 
   n, m -- non-negative integer
 
Synopsis:

     n   
    -----                                            
     \              m                             
      )   S1(n, m) x  = x (x - 1) .. (x - n + 1)
     /                                    
    -----   
    m = 0   
   
  
  (-1)^(n-m)*S1(n,m) is the number of permutations
  of n symbols which have exactly m cycles.

See also:

  stirling2

#

combinat::stirling1 := proc(n, m)
   option remember;
   local k, p, x;
begin
   if testargs() then 
      if args(0) <> 2 then 
         error("Two arguments expected.") 
      elif not testtype(m, Type::NonNegInt) or
           not testtype(n, Type::NonNegInt) then
           error(" Arguments must be non negativ integers.")
      end_if 
   end_if;

   if m > n then  
      0  
   elif m = n then 
      1  
   elif m = 1 then
      (-1)^(n-1) * fact(n-1)
   elif n = m+1 then
      -binomial(n, 2)
   else # 2 < m + 1 < n #
      # p = x^n + c[n-1] * x^(n-1) + ... + c[1] * x #
      # stirling1(n, k) = c[k]                      #
      p := poly(_mult(x-k+1 $ k = 1..n), [x]);
      for k from 1 to n do
          combinat::stirling1(n, k) := coeff(p,x,k)
      end_for;
      coeff(p,x,m) 
   end_if

end_proc:

