# $Date: 1995/07/17 09:36:31 $ $Author: kg $ $Revision: 1.10.2.1 $ #
#++
Field -- the category of fields

A Field is a SkewField and a EuclideanDomain. As such it has a commutative
'*' from EuclideanDomain and an invertible '*' from SkewField.

Methods:
euclideanDegree(x) - returns the euclidean degree of x; here 0 iff x is
                     0 and 1 otherwise
quo(x,y)           - returns the euclidean quotient of x and y; here q such
                     that x = q * y, ie. x * y^(-1)
rem(x,y)           - returns the euclidean reminder of x and y; here always 0
unitNormal(x)      - returns the unit normal part of x; here 0 iff x is 0 and 1
                     otherwise
unitNormalRep(x)   - returns the unit normal rep., here [1,1/x,x] if x <> 0
		     and [0,0,0] if x = 0
idealGenerator(x1,...,xn) - returns a generator of the ideal defined
		     by the elements x1,...,xn, ie. 0 or 1
isPrime(x)	   - returns FALSE
Factor(x)	   - returns [x]
sqrFree(x)	   - returns [x]
++#

Field:= CategoryConstructor(
    Field,
    [],
    [],
    NIL,
    [ EuclideanDomain, FactorialDomain, SkewField ],
    [ canonicalUnitNormal, closedUnitNormals ],

    "isUnit" = (not this::iszero),

    "divex" = proc(x,y) begin
        if this::iszero(y) then error("division by zero") end_if;
        this::_mult(x, this::invert(y))
    end_proc,

    "divides" = proc(y,x) begin
	if this::iszero(y) then error("division by zero") end_if;
	TRUE
    end_proc,

    "associates" = proc(x,y) begin
	if this::iszero(x) or this::iszero(y) then FALSE else TRUE end_if
    end_proc,

    "euclideanDegree" = proc(x)
    begin
        if this::iszero(x) then 0 else 1 end_if
    end_proc,
 
    "quo" = this::divex,

    "rem" = this::zero,

    "divide" = proc(x,y) begin (this::divex(x,y), this::zero) end_proc,

    "unitNormal" = proc(x)
    begin
        if this::iszero(x) then this::zero else this::one end_if
    end_proc,

    "unitNormalRep" = proc(x)
    begin
	if this::iszero(x) then
	    [this::zero, this::one, this::one]
	else
	    [this::one, this::invert(x), x]
	end_if
    end_proc,

    "gcd" = proc()
	local a;
    begin
	if nops(select([args()], not this::iszero)) = 0 then
	    this::zero 
	else 
	    this::one 
	end_if
    end_proc,

    "isPrime" = FALSE,

    "Factor" = proc(x) begin [x] end_proc,

    "sqrFree" = this::Factor

)():

