# $Date: 1995/05/17 08:44:10 $ $Author: kg $ $Revision: 1.4 $ #
#++
FiniteCollectionCat -- the category of finite collections

FiniteCollectionCat

A finite collection is a domain where each element contains a finite bag of
"things". The elements are numbered 1,..,nops(c), where nops(c) is the
number of elements in the bag.

Methods:-
nops(p)		    - returns the number of elements of p
op(p)		    - returns a sequence with all elements of p
op(p,i)		    - returns the i-th element of p
subsop(p,i=v)       - changes the i-th element op p to v
subs(p,x=y)         - substitutes x by y in each element of p
_index(p,i)         - returns the i-th element of p
set_index(p,i,v)    - changes the i-th element of p to v
map(p,f,...)        - maps f(p.i,...) to each element of p

mapCanFail(p,f,...) - like map but returns FAIL if one call of f returns FAIL
testEach(p,f,...)   - returns TRUE if f(p.i,...) returns TRUE for each element of p
testOne(p,f,...)    - returns TRUE if f(p.i,...) returns TRUE for one element of p
++#

FiniteCollectionCat:= CategoryConstructor(
    FiniteCollectionCat,
    [ ],
    [ ],
    ( ),
    [ SetCat ],
    [ ],
    
    "map", "_index", "set_index", "op", "nops", "subsop", "subs",
    
    "mapCanFail" = proc(c,f) local i, a, r; begin
        a:= args(i) $ i=3..args(0);
        for i from 1 to this::nops(c) do
            r:= f(this::_index(c,i), a);
            if r = FAIL then return(FAIL) end_if;
            c[i]:= r;
        end_for;
        c
    end_proc,

    "testEach" = proc(c,f) local i, a; begin
        a:= args(i) $ i=3..args(0);
        for i from 1 to this::nops(c) do
            if not f(this::_index(c,i), a) then return(FALSE) end_if;
        end_for;
        TRUE
    end_proc,

    "testOne" = proc(c,f) local i, a; begin
        a:= args(i) $ i=3..args(0);
        for i from 1 to this::nops(c) do
            if f(this::_index(c,i), a) then return(TRUE) end_if;
        end_for;
        FALSE
    end_proc
    
)():

