# $Date: 1995/05/17 08:44:11 $ $Author: kg $ $Revision: 1.6 $
#
#++
GcdDomain -- the category of integral domains with a gcd

A GcdDomain is an IntegralDomain with a gcd. The axioms for the gcd are:
i)	divex(x, gcd(x,y)) <> FAIL
ii)	divex(y, gcd(x,y)) <> FAIL
iii)	divex(x,z) <> FAIL and divex(y,z) <> FAIL =>
		divex(z, gcd(x,y)) <> FAIL
iv)	canonicalUnitNormal => gcd(x,y) = gcd(y,x)

Methods:
gcd(x1,x2,...) - returns the gcd of x1,x2,...
lcm(x1,x2,...) - returns the lcm of x1,x2,...
++#

GcdDomain:= CategoryConstructor(
    GcdDomain,
    [],
    [],
    NIL,
    [ IntegralDomain ],
    [],

    "gcd",

    "lcm" = proc(x,y)
	local i;
    begin
	if args(0) > 2 then y:= this::lcm(args(i) $ i=2..args(0)) end_if;
	this::_mult(x, this::divex(y, this::gcd(x, y)))
    end_proc

)():

