# $Date: 1995/07/17 09:36:32 $ $Author: kg $ $Revision: 1.9.2.1 $ #
#++
IntegralDomain -- the category of integral domains

An IntegralDomain is a CommutativeRing and an EntireRing such that
x = divex(a,b) and x <> FAIL implies that x is unique:

	i)  b <> 0 and divex(a,b) <> FAIL ==> b * divex(a,b) = a
	ii) a = b * c ==> divex(a,b) <> FAIL

Use the axiom canonicalUnitNormal to state in addition that unitNormal(x)
returns a unique associate among the associate class of x, ie. that
	associates(x,y) implies unitNormal(x) = unitNormal(y)

Use the axiom closedUnitNormals in addition to state that unitNormals's are
closed under multiplication, ie. that
	x = unitNormal(a) * unitNormal(b) implies unitNormal(x) = x

These two axioms are not implizitly valid for an IntegralDomain!

Methods:-
divex(x,y)       - returns a divisor d such that x = d*y if y <> 0 or FAIL;
	           if the result isn't FAIL then d is unique
divides(x,y)     - returns TRUE if x divides y
associates(x,y)  - returns TRUE iff x and y are associates
isUnit(x)	 - returns TRUE iff x is a unit
unitNormalRep(x) - returns a list [n,u,v] where n is an associate of x, u is a
		   unit and v is the inverse of u such that u*x = n and
		   u*v = 1; note that the associate returned is only unique
		   (in the associate class) if the axiom canonicalUnitNormal
		   states it
unitNormal(x)    - returns unitNormalRep(x)[1], ie. an associate of x
++#

IntegralDomain:= CategoryConstructor(
    IntegralDomain,
    [],
    [],
    NIL,
    [ EntireRing, CommutativeRing, Algebra(this) ],
    [],

    "divex", "isUnit",

    "divides" = proc(x,y) begin bool(this::divex(y,x) <> FAIL) end_proc,

    "associates" = proc(x,y) begin
	bool(this::divides(x,y) and this::divides(y,x))
    end_proc,

    "unitNormal" = ( if not this::hasProp(canonicalUnitNormal) then
	id
    else
	toBeDefined
    end_if ),

    "unitNormalRep" = ( if not this::hasProp(canonicalUnitNormal) then
	proc(x) begin [x,this::one,this::one] end_proc
    else
	proc(x) local n, u; begin
	    if this::iszero(x) then
	        [ this::zero, this::one, this::one ]
	    else
		n:= this::unitNormal(x);
		u:= this::divex(n,x);
		[ n, u, this::divex(this::one,u) ]
	    end_if
	end_proc
    end_if )

)():

