# $Date: 1995/05/17 08:44:18 $ $Author: kg $ $Revision: 1.7 $ #
#++
LeftModule -- the category of left-R-modules

LeftModule(R)

R - a Rng

A LeftModule is a AbelianGroup together with a Rng R with an
left multiplikation '*' : (R,this) -> this.

Axioms for ring elements a, b and module elements x, y:
	(a * b) * x = a * (b * x)
	(a + b) * x = a * x + b * x
	a * (x + y) = a * x + a * y

Beware: If a SemiGroup is also a LeftModule the multiplication '*'
has 2 signatures: '*' : (this,this) -> this and '*' : (R,this) -> this.
The implementation of the multiplication must handle this. The same
kind of problem is occuring if a domain is a LeftModule over more
than one rng.

Methods:-
_mult(r,x) - returns the left multiplikation r*x of x by the rng element r
++#

LeftModule:= CategoryConstructor(
    LeftModule,
    [ R ],
    [],
    (if args(0) <> 1 then error("wrong no of args") end_if;
     if not R::hasProp(Rng) then error("no rng") end_if),

    [ AbelianGroup ],
    [],

    "_mult"

):

