# $Date: 1995/05/26 07:58:30 $ $Author: kg $ $Revision: 1.16 $ #
#++
PolynomialCat -- the category of polynomials

PolynomialCat(R)

R - coefficient ring

Methods:
indets(p)        - returns list of indeterminates of p
mainvar(p)	 - returns the main variable of p
degree(p)        - returns total degree of p
degree(p,x)      - returns degree of variable x
degreevec(p)     - returns exponent list of leading term
evalp(p,x=v...)  - evaluates p at x = v
lcoeff(p)        - returns leading coefficient of p
lmonomial(p)     - returns leading monomial of p
lterm(p)         - returns leading term of p
nterms(p)        - returns number of non-zero terms of p
nthterm(p,n)     - returns term number n of p, the order may be not represent
		   the term ordering given by 'lcoeff'.
nthcoeff(p,n)    - returns coefficient number n of p
nthmonomial(p,n) - returns monomial number n of p
tcoeff(p)        - returns the trailing coefficient of p
coeff(p)         - returns a list of all non-zero coefficients
coeff(p,x,n)     - returns the coefficient of x^n
coeff(p,n)       - returns the coefficient of x^n where x is the main variable
multcoeffs(p,c)  - multiplies the coefficients of p by c
mapcoeffs(p,f,a...) - replaces the coefficients ci of p by f(ci,a,...)
content(p)       - returns the content of p
primpart(p)      - returns the primitive part of p

Entries:
coeffRing	 - the coefficient ring
++#

PolynomialCat:= CategoryConstructor(
    PolynomialCat,
    [ R ],
    [ ],
    ( if args(0) <> 1 then error("wrong no of args") end_if;
      if R::hasProp(CommutativeRing) <> TRUE then
	error("no commutative ring")
      end_if ),
    [ ( if R::hasProp(FactorialDomain) then
	    FactorialDomain
        elif R::hasProp(GcdDomain) then
	    GcdDomain
        elif R::hasProp(IntegralDomain) then
	    IntegralDomain
	end_if ),
      PartialDifferentialRing,
      Algebra(R) ],
    [ ( if R::hasProp(canonicalUnitNormal) then
	    canonicalUnitNormal
	end_if ),
      ( if R::hasProp(closedUnitNormals) then
	    closedUnitNormals
	end_if ) ],

    "indets", "mainvar", "degree", "degreevec", "lcoeff", "lmonomial",
    "lterm", "nterms", "nthterm", "nthcoeff", "nthmonomial", "tcoeff",
    "coeff", "multcoeffs", "mapcoeffs", "evalp",

    "coeffRing" = R,

    "characteristic" = R::characteristic,
    
    "content" = (if R::hasProp(Field) then
	R::one
    elif R::hasProp(GcdDomain) then
	R::gcd @ this::coeff
    end_if),

    "primpart" = (if R::hasProp(Field) then
	this::unitNormal
    elif R::hasProp(GcdDomain) then
	proc(x) begin
	    this::unitNormal(mapcoeffs(x, R::divex, this::content(x)))
	end_proc
    end_if),

    "unitNormalRep" = (if R::hasProp(canonicalUnitNormal) then
	proc(x) local n; begin
	    n:= R::unitNormalRep(this::lcoeff(x));
	    [ this::multcoeffs(x, n[2]), this::new(n[2]), this::new(n[3]) ]
	end_proc
    end_if),

    "unitNormal" = (if R::hasProp(canonicalUnitNormal) then
	proc(x) begin
	    this::multcoeffs(x, (R::unitNormalRep(this::lcoeff(x)))[2])
	end_proc
    end_if),

    "isUnit" = proc(x) begin
        if this::degree(x) > 0 then FALSE
        else R::isUnit(this::lcoeff(x))
        end_if
    end_proc

):

