# #
# $Date: 1995/05/26 07:58:35 $ $Author: kg $ $Revision: 1.13 $ #
# #
# frankp, 13/06/94 #

#++
SquareMatrixCat -- the category of square matrices

SquareMatrixCat(R)

R - coefficient domain (a Rng)

The category SquareMatrixCat(R) represents the category of all
square matrices of the Rng R.

The super-category of SquareMatrixCat(R) is MatrixCat(R).
This ensures that a method for MatrixCat(R) may be used by
SquareMatrixCat(R).
++#

SquareMatrixCat := CategoryConstructor(
# name #
    SquareMatrixCat,
# arguments #
    [ R ],
# local variables #
    [ ],
# initialisation #
    (if args(0) <> 1 then error("wrong no of args") end_if;
     if R::hasProp(Rng) <> TRUE then
	error("coefficients must be from a Rng")
    end_if),
# super categories #
    [ (if R::hasProp(Ring) then Ring else Rng end_if),
      MatrixCat(R) ],
# axioms #
    [ ],
    
    "characteristic" = (if R::hasProp(Ring) then R::characteristic end_if)
    
):

