# $Date: 1995/03/07 18:35:37 $ $Author: kg $ $Revision: 1.4 $ #

#++
func_call -- create a new axiom using axiom constructor

func_call(AC,a1,...)

AC     - axiom constructor
a1,... - actual parameters of axiom

The axiom is an element of the domain 'Axiom'. It merely holds the
constructor and the actual parameters and locals.

One can't remember the existing axioms with 'option remember'
because of the implicit 'option hold' of func_call.
++#

AxiomConstructor::func_call:= proc(AC)
    local call, i, A, ACargs;
begin
    # 'func_call' has option hold implicitly #
    AC:= context(AC);
    call:= context([args(i) $ i = 2..args(0)]);

    # test arguments #
    if testargs() then
        if args(0) = 0 then error("wrong no of args") end_if;
        if domtype(AC) <> AxiomConstructor then
            error("no axiom constructor")
        end_if;
    end_if;

    # compute actual values of locals #
    ACargs:= extop(AC,3)(op(call));
    if domtype(ACargs) <> DOM_LIST then
        error("invalid constructor")
    end_if;
    if nops(ACargs) <> nops(extop(AC,2)) then
        error("invalid constructor")
    end_if;

    # does the axiom already exist? #
    A:= domattr(extop(AC,4), ACargs);
    if A <> FAIL then return(A) end_if;

    # create axiom and remember it #
    A:= new(Axiom, AC, extop(AC,5), op(ACargs));
    domattr(extop(AC,4), ACargs):= A;
    A
end_proc:

# end of file #
