# $Date: 1995/04/26 08:13:40 $ $Author: kg $ $Revision: 1.5 $ #

#++
func_call -- create new category using constructor

func_call(CC,a1,...)

CC     - category constructor
a1,... - actual category parameters

The category is an element of the domain 'Category'. It merely holds
the constructor and the actual parameters. Entries are created later on
the fly when a domain needs them.

One can't remember the existing categories with 'option remember'
because of the implicit 'option hold' of func_call.
++#

CategoryConstructor::func_call:= proc(_0_CC)
    local _0_call, _0_C, _0_CCargs;
begin
    # 'func_call' has option hold implicitly #
    _0_CC:= context(_0_CC);
    _0_call:= context([args(i) $ hold(i)=2..args(0)]);

    # test arguments #
    if testargs() then
        if args(0) = 0 then error("wrong no of args") end_if;
        if domtype(_0_CC) <> CategoryConstructor then
            error("no axiom constructor")
        end_if;
    end_if;

    # compute actual values of locals #
    _0_CCargs:= extop(_0_CC,3)(op(_0_call));
    if domtype(_0_CCargs) <> DOM_LIST then
        error("invalid constructor")
    end_if;
    if nops(_0_CCargs) <> nops(extop(_0_CC,2)) then
        error("invalid constructor")
    end_if;

    # does the category already exist? #
    _0_C:= domattr(extop(_0_CC,7), _0_CCargs);
    if _0_C <> FAIL then return(_0_C) end_if;

    # create category and remember it #
    _0_C:= new(Category, _0_CC, extop(_0_CC,8), _0_CCargs);
    domattr(extop(_0_CC,7), _0_CCargs):= _0_C;
    _0_C
end_proc:

# end of file #
