# $Date: 1995/06/28 09:10:52 $ $Author: kg $ $Revision: 1.12.2.1 $ #
#++
Category -- the domain of categories

A category is represented as element of the domain 'Category' with
operands:

 0 - the domain 'Category'
 1 - the category constructor, an element of the domain
     'CategoryConstructor'
 2 - the number of formal parameters
 3 - a list of the actual parameters and locals of the category

The implementation of the domain 'CategoryConstructor' strongly depends 
on the representation of categories defined here (because of performance
reasons). Do not change!

A category has no entries which may be used as domain entries
directly.  Such entries are created on the fly by the category
constructor.  A category merely stores the actual parameters of the
catgory.

None of the methods defined here are normally called directly by the
category implementor or user. They are called implizitly.

Only the method 'elemattr' may be used within the definition of a
category or domain constructor in order to obtain certain entries of
categories directly. This method may not be used in any other context!

Procedures calling category constructor procedures must have strange
parameter and variable names because these names may otherwise conflict
with names evaluated by the constructor (via 'eval').
++#

Category:= domain():
Category::name:= "Category":
Category::info:= "Domain 'Category'":
Category::interface:= {}:
Category::subs:= fun(args(1)):

#++
constructor -- return constructor of Category

constructor(C)

C - category
++#

Category::constructor:= fun((
    if testargs() then
        if args(0) <> 1 then error("wrong no of args") end_if;
        if domtype(args(1)) <> Category then
            error("no category")
        end_if;
    end_if;
    extop(args(1), 1)
)):

#++
elemattr -- get entry of category, changing it into domain entry

elemattr(C, e)

C - category
e - name of entry to get

'elemattr' is used to get the entry 'e' of category 'C' directly. The
entry is implicitly changed into a domain entry (by 'getDirectEntry').

'elemattr' may only be used within the definition of category contructors
with 'CategoryConstructor::new'. It is not allowed in any other
context!
++#

Category::elemattr:= fun((
    if testargs() then
        if args(0) <> 2 then error("wrong no of args") end_if;
        if domtype(args(2)) <> DOM_STRING then
            error("invalid operator name")
        end_if;
    end_if;
    CategoryConstructor::getNamedEntry(args())
)):

#++
new -- create new category using category constructor

new(CC,n,l)

CC - category constructor
n  - number of formal parameters
l  - list of actual category parameters (may be empty)
++#

Category::new:= fun((
    if testargs() then
        if args(0) <> 3 then error("wrong no of args") end_if;
        if domtype(args(1)) <> CategoryConstructor then
            error("no category constructor")
        end_if;
        if domtype(args(2)) <> DOM_INT then
            error("no parameter count");
        end_if;
        if domtype(args(3)) <> DOM_LIST then
            error("illegal parameter list");
        end_if;
    end_if;
    new(Category, args())
)):

#++
print -- print category

print(C)

C - category
++#

Category::print:= fun((
    if extop(args(1),2) = 0 then
        extop(extop(args(1),1), 1)
    else
        extop(extop(args(1),1), 1)
            (op(extop(args(1),3), 1..extop(args(1),2)))
    end_if
)):

#++
TeX -- return TeX formatted string for category

TeX(C)

C - category
++#

Category::TeX:= fun(TeX(Category::print(args(1)))):

#++
testtype -- test type of category

testtype(e, T)

e - expression
T - type

Returns TRUE if e is an Category and T is Category and FAIL otherwise.
++#

Category::testtype:= fun((
    if args(2) = Category then
        if domtype(args(1)) = Category then
            return(TRUE)
        end_if
    end_if;
    FAIL
)):

# end of file #
