# $Date: 1995/05/10 07:21:35 $ $Author: kg $ $Revision: 1.8 $ #

#++
allSuperDomainEntries -- get all entries of super-domains

allSuperDomainEntries(this, defined, undefined)

this      - domain
defined   - set with defined entries
undefined - set with 'to be defined' entries

Searches for entries in line with getSuperDomainEntry. The names of the
entries are inserted in the sets 'undefined' and 'defined'. Returns
a list with the two sets.
++#

DomainConstructor::allSuperDomainEntries:= proc(this,_0_d,_0_u)
    local _0_SD, _0_r, _0_e;
begin
    for _0_SD in (args(1))::super_domains do

	# search for entry in super-domain constructor #
	for _0_e in extop(_0_SD::constructor,7) do
	    _0_e:= op(_0_e,1);
	    if contains(_0_d, _0_e) then next end_if;
	    if contains(_0_u, _0_e) then next end_if;

	    # substitute actual domain and super-domain param's and return
	      evaluated result, use 'index_val' to get table entries in order
	      to avoid early evaluation #
	    _0_r:= DomainConstructor::subsArgs(
			index_val(extop(_0_SD::constructor,7), _0_e),
			_0_SD, args(1));

	    # toBeDefined means: this entry should have been defined elsewhere #
	    if _0_r = hold(toBeDefined) then
		_0_u:= _0_u union {_0_e}
	    elif _0_r <> hold(_0_r) then
		_0_d:= _0_d union {_0_e}
	    end_if;
	end_for;
    end_for;
    [ _0_d, _0_u ]
end_proc:

# end of file #
