# $Date: 1995/05/10 07:21:36 $ $Author: kg $ $Revision: 1.7 $ #

#++
makeEntry -- create an entry for a domain

makeEntry(this, e)

this - domain
e    - entry name (string)

makeEntry searches for a definition of a domain entry and creates
the entry if its definition is found.

makeEntry returns a list with 2 entries:
1- the entry found or toBeDefined or FAIL
2- the domain or category which defined the entry or FAIL
++#

DomainConstructor::makeEntry:= proc(this#,e#)
    local _0_C, _0_r;
begin
    # search for entry in constructor #
    if contains(extop((args(1))::constructor,7), args(2)) then

        # substitute actual domain and its param's and return evaluated result,
          use 'index_val' to get table entries in order to avoid early
          evaluation #
        _0_r:= DomainConstructor::subsArgs(
		index_val(extop((args(1))::constructor,7), args(2)), 
		args(1), args(1));

        if _0_r <> hold(_0_r) then
            return([_0_r, args(1)])
        end_if;
    end_if;

    # search for entry in super-domains #
    _0_r:= DomainConstructor::getSuperDomainEntry(args());
    if _0_r[1] <> FAIL then return(_0_r) end_if;

    # search for entry in categories #
    CategoryConstructor::getEntry(args());
end_proc:

# end of file #
