# $Date: 1994/11/07 13:22:56 $ $Author: kg $ $Revision: 1.1 $ #

#++
domains::optimize -- optimizes a method of a domain

domains::optimize(p)

p - procedure or pure function

returns the optimization of p

optimize replaces expressions of the form 'domattr(D,e)' with constant
arguments D and e by the corresponding domain entries.

Further on domain entries which are defined to be 'Inline' are inlined
(ie. the body of these methods are inserted directly instead of the method call).

Not that optimizing 'freezes' the meaning of entries inside of an
optimized method. If a method p uses the entry 'sin' for example
and p is optimized the definition of sin is inserted into the procedure at
the time when the optimization takes place. If sin is changed later on the
change has no effect in p.

optimize evaluates domain entries and hitero may cause the optimization
of other methods. In order to avoid infinite recursion methods which are
beeing optimized are not evaluated. Example:
	D::f:= proc(x,y) begin D::f(x,y)^2 end_proc
would cause an inifinite optimization of D::f if no precaution would be 
taken. Methods which are beeing optimized are inserted into the
entry domains::optimizeEntries.
++#

domains::optimize:= proc(#p, loc#)
    local _0_loc;
begin
    if args(0) = 1 then
    	_0_loc:= {}
    elif args(0) = 2 then
    	_0_loc:= args(2)
    else error("wrong no of args") end_if;

    case domtype(args(1))
    of DOM_PROC do
    	_0_loc:= (_0_loc union {op(args(1),1)} union {op(args(1),2)}) minus {NIL};
    	subsop(args(1), 4=domains::optimize_body(op(args(1),4), _0_loc));
    	break;
    of DOM_EXEC do
    	# is p a fun? #
    	if op(args(1),1) = 112 then
    	    subsop(args(1), 5=domains::optimize_body(op(args(1),5), _0_loc))
    	else
    	    args(1)
    	end_if;
    	break;
    otherwise
    	args(1)
    end_case
end_proc:


#--
domains::optimize_body -- optimize body of prozedure or pure function

domains::optimize_body(b, loc)

b   - the body (expression)
loc - local variables and formal parameters (set of idents)

The expression b is optimized by evaluating domattr-calls
by the corresponding domain entries and inlining methods if possible.
--#

domains::optimize_body:= proc(_0_b #, loc#)
    local _0_f, _0_D;
begin
    # if domains::optimize_body has more than 2 args it was called with an
      expression sequenze (the sequenze has been flattened). In such a case
      we optimize the operands of the sequence and 'reconstruct' the sequence. #
    if args(0) > 2 then
    	return(hold(_exprseq)(domains::optimize_body(args(i), args(args(0))) 
    				$ hold(i)=1..args(0)-1))
    end_if;
    
    case domtype(_0_b)
    of DOM_PROC do
    	_0_b:= domains::optimize(_0_b, args(2));
    	break;
    of DOM_EXEC do
    	# is b a fun? #
    	if op(_0_b,1) = 112 then _0_b:= domains::optimize(_0_b, args(2)) end_if;
    	break;
    of DOM_LIST do
    of DOM_SET do
    of DOM_ARRAY do
    	_0_b:= map(_0_b, domains::optimize_body, args(2));
    	break;
    of DOM_TABLE do
    	_0_b:= table((domains::optimize_body(op(_0_b,[i,1]), args(2)) = 
   		      domains::optimize_body(op(_0_b,[i,2]), args(2)))
			$ hold(i)=1..nops(_0_b));
    	break;
    of DOM_EXPR do
    	_0_f:= op(_0_b,0);
    	
    	# optimize operands; be careful not to remove hold's or to flatten
    	  expression sequences; optimize local proc's and fun's #
    	case _0_f
    	of hold(domattr) do
    	    # found domattr(D,e), should it evaluate to an entry? #
    	    _0_f:= op(_0_b,1);
    	    if contains(args(2), _0_f) then return(_0_b) end_if;
    	    _0_f:= level(_0_f);
    	    if domtype(_0_f) <> DOM_DOMAIN then return(_0_b) end_if;
    	    if contains(domains::optimizeEntries, [_0_f, op(_0_b,2)]) then
    	    	return(_0_b)
    	    end_if;
    	    _0_f:= domattr(_0_f, op(_0_b,2));
    	    return((if _0_f = FAIL then _0_b else _0_f end_if));
    	    
    	of hold(hold) do
    	    return(_0_b);
    	of hold(_index) do
    	of hold(_exprseq) do
	    return(_0_f(
		(if op(_0_b,i) = NIL then NIL
		 else domains::optimize_body(op(_0_b,i), args(2)) end_if)
		 $ hold(i)=1..nops(_0_b)));
    	of hold(fun) do
    	of hold(_procdef) do
    	    return(domains::optimize(level(_0_b), args(2)));    	
    	end_case;
	#
	_0_b:= _0_f((if op(_0_b,i) = NIL then NIL
		    else domains::optimize_body(op(_0_b,i), args(2)) end_if)
		    $ hold(i)=1..nops(_0_b));
	#
	_0_b:= subsop(_0_b,
		   (if op(_0_b,i) = NIL then null()
		    else i=domains::optimize_body(op(_0_b,i), args(2)) end_if)
		    $ hold(i)=1..nops(_0_b), Unsimplified);
	if domtype(_0_f) = DOM_IDENT then break end_if;

	# is operator an entry to be inlined? #
	_0_f:= domains::optimize_body(_0_f, args(2));
	if type(op(_0_b,0)) = "domattr" then
	    _0_D:= op(_0_b,[0,1]);
	    _0_D:= domattr(level(_0_D), "inlineEntries");
	    if _0_D <> FAIL then
	    	if contains(_0_D, op(_0_b,[0,2])) then
	    	    _0_b:= domains::do_inline(_0_b, _0_f);
	    	    break
	    	end_if
	    end_if
	end_if;
	_0_b:= subsop(_0_b, 0=_0_f, Unsimplified);
    end_case;
    _0_b
end_proc:

#--
domains::do_inline -- inline procedure or function into expression

domains::do_inline(e, f)

e - procedure or function call
f - procedure or function to inline

returns expression e with f inlined

The operand of the expression e is inlined by using the body of the procedure
or pure function f.
--#

domains::do_inline:= proc(e, f)
    local Args, Params;
begin
    case domtype(f)
    of DOM_PROC do
    	if op(f,2) <> NIL then error("can't inline local vars") end_if;
    	if op(f,4) = NIL then error("empty body") end_if;
    	Args:= e;
    	Params:= (if op(f,1) = NIL then [] else [op(f,1)] end_if);
    	return(domains::inline_body(op(f,4)));
    of DOM_EXEC do
    	# is f a fun? #
    	if op(f,1) <> 112 then break end_if;
    	Args:= e;
    	Params:= [];
    	return(domains::inline_body(op(f,5)));
    end_case;
    subsop(e, 0=f, Unsimplified);
end_proc:

#--
domains::inline_body(b)

b - body of the procedure or function to inline

Uses global vars Params and Args from domains::do_inline.

Returns expression b^ such that every formal parameter inside of b is
replaced by the correspondig actual parameter in Args. The formal parameters
may be identifiers contained in Params or expressions of the form args(n).
--#

domains::inline_body:= proc(b)
    local i, n, f;
begin
    if args(0) > 1 then
    	return(hold(_exprseq)(domains::inline_body(args(i)) $ i=1..args(0)))
    end_if;
    n:= contains(Params, b);
    if n <> 0 then return(op(Args,n)) end_if;
    case domtype(b)
    of DOM_LIST do
    of DOM_SET do
    of DOM_ARRAY do
    	b:= map(b, domains::inline_body);
    	break;
    of DOM_TABLE do
    	b:= table((domains::inline_body(op(b,[i,1])) = 
    	           domains::inline_body(op(b,[i,2]))) $ i=1..nops(b));
    	break;
    of DOM_EXPR do
    	f:= op(b,0);
    	case f
    	of hold(args) do
    	    n:= op(b,1);
    	    if domtype(n) <> DOM_INT then error("can't inline args(<expr>)") end_if;
    	    if n < 0 then error("args() with negative index") end_if;
    	    if n > nops(Args) then error("too few actual parameters") end_if;
    	    return((if n = 0 then nops(Args) else op(Args,n) end_if));
    	of hold(hold) do
    	    return(b);
    	of hold(_index) do
    	of hold(_exprseq) do
	    return(f(
		(if op(b,i) = NIL then NIL
		 else domains::inline_body(op(b,i)) end_if)
		 $ i=1..nops(b)));
    	of hold(_assign) do
    	    error("assignment not allowed");
    	end_case;
    	#
    	b:= domains::inline_body(f)(
		(if op(b,i) = NIL then NIL
		 else domains::inline_body(op(b,i)) end_if)
		 $ i=1..nops(b));
	#
	b:= subsop(b,
		(if op(b,i) = NIL then null()
		 else i=domains::inline_body(op(b,i)) end_if)
		 $ i=0..nops(b), Unsimplified);
	break;
    of domtype(newfuncarg(1)) do
    	# error in newfuncarg, can't handle this case #
    	error("not yet implemented");
    end_case;
    b
end_proc:

# end of file #
