# $Date: 1995/06/28 10:01:46 $ $Author: kg $ $Revision: 1.9.2.1 $ #
#++
ArithmeticalExpression -- the domain of arithmetical expressions

The domain of arithmetical expressions built up by the internal
operators '+', '*', etc. This domain has almost no algebraic
structure because expressions have no normal form (rational expressions
for example are not normalized to zero).

Use ExpressionField if you can supply a normalizing function
for a class of expressions which makes that class a field.

Entries:-
zero             - the element 0
one              - the element 1

Methods:-
iszero(e)        - returns TRUE iff e is zero
_plus(x1,x2,...) - returns the sum of the xi
negate(x)        - returns -x
minus(x,y)       - returns x-y
_mult(x1,x2,...) - returns the product of the xi
invert(x)        - returns 1/x
intmult(x,i)     - returns i times x
_power(x,y)      - returns x^y
divex(x,y)       - returns x/y

convert(e)       - convert the expression e into an ArithmeticalExpression,
		   ie. e itself
++#

ArithmeticalExpression:= DomainConstructor(

    ArithmeticalExpression,
    [ ],
    [ ],
    NIL,
    Expression,
    [ SetCat ],
    [ systemRep ],

    "zero" = 0,

    "iszero" = iszero,

    "one" = 1,

    "_plus" = _plus,

    "negate" = - id,

    "minus" = proc(x,y) begin x - y end_proc,

    "_mult" = _mult,

    "invert" = 1 / id,

    "intmult" = _mult,

    "_power" = _power,

    "divex" = proc(x,y) begin x / y end_proc,

    "D" = D,

    "diff" = diff,

    "convert" = proc(e)
        local conv;
    begin    
	conv:= fun((
	    domtype(args(1));
	    if contains({DOM_INT, DOM_RAT, DOM_FLOAT, DOM_COMPLEX, DOM_IDENT}, %) then
	        args(1)
	    elif % = DOM_EXPR then
	        if contains(map({ op(args(1)) }, conv), FAIL) then FAIL else args(1) end_if
	    else
	        FAIL
	    end_if
	));
	
	conv(expr(e))
    end_proc

)():

