# $Date: 1995/05/17 08:45:11 $ $Author: kg $ $Revision: 1.7 $ #
#++
FreeStruc -- domain constructor for

FreeStruc(S)

S - Domain that represents an algebraic structure

FreeStruc(S) creates the free algebraic structure of S.
++#


FreeStruc :=
DomainConstructor(
   # Name des Domains #
   FreeStruc,

   # Parameter #
   [ S ],
   [ ],

   # Parameterpr"ufung #
   ( if args(0) <> 1 then error("wrong no of args") end_if;
     if domtype(S) = DOM_DOMAIN then
        if not S::hasProp(Group) then
           error("argument must be a Group") ;
        end_if ;
      else
        error("illegal argument") ;
     end_if), # S sollte mindestens eine Gruppe repr"asentieren #

   # Super - Domains #
   BaseDomain,

   # Kategorien #
   [(if S::hasProp(Field) then
        Field ;
     elif S::hasProp(IntegralDomain) then
        IntegralDomain ;
     elif S::hasProp(Ring) then
        Ring ;
     elif S::hasProp(AbelianGroup) then
        AbelianGroup ;
     else
        Group
     end_if) ],

   # Axiome #
   [ ],

   # Eintr"age #
   "_plus" =
      (if S::hasProp(Field) then
         proc(x)
            local i ;
         begin
            x := extop(x, 1) ;
            for i from 2 to args(0) do
               x := x + extop(args(i), 1) ;
            end_for ;
            new(this, x) ;
         end_proc ;
      elif S::hasProp(Ring) then
      elif S::hasProp(AbelianGroup) then
               proc(x)
            local i ;
         begin
            x := extop(x, 1) ;
            for i from 2 to args(0) do
               x := x + extop(args(i), 1) ;
            end_for ;
            new(this, x) ;
         end_proc ;
      end_if) ,

   "negate" =
      (if S::hasProp(Field) then
         proc(x)
         begin
            new(this, -extop(x, 1)) ;
         end_proc ;
      elif S::hasProp(Ring) then 
      elif S::hasProp(AbelianGroup) then 
         proc(x) 
         begin 
            new(this, -extop(x, 1)) ; 
         end_proc ;
      end_if) , 

   "subtract" =
      (if S::hasProp(Field) then 
         proc(x,y)  
         begin 
            new(this, extop(x, 1)-extop(y,1)) ; 
         end_proc ; 
      elif S::hasProp(Ring) then  
      elif S::hasProp(AbelianGroup) then  
         proc(x,y)  
         begin  
            new(this, extop(x, 1)-extop(y,1)) ;  
         end_proc ; 
      end_if) ,  
 
   "zero" = new(this, S::zero),

   "iszero" =
      proc(x)
      begin
         bool ( x = R::zero )
      end_proc ,

   "_mult" =
      (if S::hasProp(Field) then 
         proc(x)  
            local i ;
         begin 
            x := extop(x, 1) ;
            for i from 2 to args(0) do
               x := x * extop(args(i), 1) ;
            end_for ;
            new(this, x) ;
         end_proc ; 
      end_if) ,  
 
   "intmult" =
      (if S::hasProp(Field) then 
         proc(x, i)  
         begin 
            new(this, i * extop(x, 1)) ; 
         end_proc ; 
      elif S::hasProp(Ring) then  
      elif S::hasProp(AbelianGroup) then  
         proc(x, i)  
         begin  
            new(this, i * extop(x, 1)) ;  
         end_proc ; 
      end_if) ,  
 
   "invert" =
      (if S::hasProp(Field) then 
         proc(x)  
         begin 
            new(this, 1/extop(x, 1)) ; 
         end_proc ; 
      end_if) ,  
 
   "one" =
      (if S::hasProp(Field) then 
         new(this, S::one) ;
      elif S::hasProp(IntegralDomain) then  
         new(this, S::one) ;
      elif S::hasProp(Ring) then  
         new(this, S::one) ;
      end_if) ,  

   "_power" =
     (if S::hasProp(Field) then
         proc(x,i)
         begin
            new(this, extop(x,1) ^ i) ;
         end_proc ;
      end_if) ,
 
   "new" =
      proc(x)
      begin
         new(this, x) ;
      end_proc ,

   "convert" =
      proc(x)
      begin
         if domtype(x) = this then
            return (x)
         end_if ;
         this::new(x) ;
      end_proc ,

   "expr" =
      proc(x)
      begin
         extop(x,1) ;
      end_proc ,

   "print" =
      proc(x)
      begin
         extop(x, 1) ;
      end_proc
) :

