# $Date: 1995/05/17 08:45:14 $ $Author: kg $ $Revision: 1.18 $ #
#++
Fraction -- the domain of fractions over R

Fraction(R)

R - integral domain

Fractions are represented as new(this,n,d) where n and d are from R,
n is the numerator and d is the denominator.

Methods:
numer(x)       - returns the numerator of x
denom(x)       - returns the denominator of x
retract(x)     - returns numer(x)/denom(x) if this is an element of R and
	         FAIL otherwise
normalize(x,y) - returns the fraction x/y, 0/y is normalized to 0/1; in a
		 GcdDomain the gcd of x and y is removed.
normalizePrime(x,y) - returns the fraction x/y, 0/y is normalized to 0/1;
		 in a GcdDomain it is assumed that x and y are
		 relative prime, the gcd of x and y is not removed.
++#

Fraction:= DomainConstructor(
    Fraction,
    [ R ],
    [ ],
    ( if args(0) <> 1 then error("wrong no of args") end_if;
      if R::hasProp(IntegralDomain) <> TRUE then
	error("no integral domain")
      end_if ),
    BaseDomain,
    [ QuotientField(R),
      ( if R::hasProp(DifferentialRing) then
	    DifferentialRing
	elif R::hasProp(PartialDifferentialRing) then
	    PartialDifferentialRing
	end_if ) ],
    [ ( if R::hasProp(canonicalRep) and R::hasProp(GcdDomain) and
	 R::hasProp(canonicalUnitNormal) then
	    canonicalRep
        else
            normalRep
        end_if) ],

    "convert" = ( if R = Integer then
	proc(x) begin
	    case domtype(x)
	    of DOM_INT do return(this::normalizePrime(x, 1));
	    of DOM_RAT do return(this::normalizePrime(op(x,1), op(x,2)));
	    end_case;
	    FAIL
	end_proc
    else
	proc(x) local c, i; begin
	    case type(x)
	    of "_plus" do
		c:= [ this::convert(op(x,i)) $ i=1..nops(x) ];
		if contains(c, FAIL) > 0 then break end_if;
		return(this::_plus(op(c)));
	    of "_mult" do
		c:= [ this::convert(op(x,i)) $ i=1..nops(x) ];
		if contains(c, FAIL) > 0 then break end_if;
		return(this::_mult(op(c)));
	    of "_power" do
		if domtype(op(x,2)) <> DOM_INT then break end_if;
		c:= this::convert(op(x,1));
		if c = FAIL then break end_if;
		return(this::_power(c,op(x,2)));
	    of "function" do
		if R::hasProp(DifferentialRing) then
		    if op(x,0) <> hold(D) or nops(x) <> 1 then break end_if;
		    c:= this::convert(op(x,1));
		    if c = FAIL then break end_if;
		    return(this::D(c));
		elif R::hasProp(PartialDifferentialRing) then
		    if op(x,0) <> hold(D) or nops(x) <> 2 then break end_if;
		    c:= this::convert(op(x,2));
		    if c = FAIL then break end_if;
		    if not testtype(op(x,1), Type::ListOf(Type::PosInt)) then
			break
		    end_if;
		    return(this::D(op(x,1), c));
		end_if;
	    end_case;

	    c:= R::convert(x);
	    if c = FAIL then return(FAIL) end_if;
	    this::normalize(c, R::one)
	end_proc
    end_if ),

    "expr" = proc(x) begin
	R::expr(extop(x,1)) / R::expr(extop(x,2))
    end_proc,

    "convert_to" = proc(x,T) begin
	case T
	of this do return(x);
	of Expression do
	of ArithmeticalExpression do return(this::expr(x));
	end_case;
	FAIL
    end_proc,

    "TeX" = proc(x) begin
	"\\frac{".R::TeX(extop(x,1))."}{".R::TeX(extop(x,2))."}"
    end_proc,

    "numer" = proc(x) begin extop(x,1) end_proc,

    "denom" = proc(x) begin extop(x,2) end_proc,

    "iszero" = proc(x) begin R::iszero(extop(x,1)) end_proc,

    "normalizePrime" = (if R::hasProp(GcdDomain) then
	proc(x, y) local d; begin
	    if R::iszero(x) then
		this::zero
	    else
		d:= R::unitNormalRep(y);
		new(this, R::_mult(x, d[2]), d[1])
	    end_if
	end_proc
    else this::normalize end_if),

    "normalize" = (if R::hasProp(GcdDomain) then
	proc(x,y) local g; begin
	    if R::iszero(x) then
		this::zero
	    else
		g:= R::gcd(x,y);
		y:= R::unitNormalRep(R::divex(y,g));
		new(this, R::_mult(R::divex(x,g), y[2]), y[1])
	    end_if
	end_proc
    else
	proc(x,y) begin
	    if R::iszero(x) then
		this::zero
	    else
		new(this, x, y)
	    end_if
	end_proc
    end_if),

    "equal" = (if not this::hasProp(canonicalRep) then
	proc(x,y) begin
	    R::equal(R::_mult(extop(x,1), extop(y,2)),
		     R::_mult(extop(y,1), extop(x,2)))
	end_proc
    end_if),

    "_less" = ( if R::hasProp(OrderedSet) then
	proc(x,y) begin
	    R::_less(R::_mult(extop(x,1), extop(y,2)),
		     R::_mult(extop(y,1), extop(x,2)))
	end_proc
    end_if ),

    "zero" = new(this, R::zero, R::one),

    "iszero" = proc(x) begin R::iszero(extop(x,1)) end_proc,

    "one" = new(this, R::one, R::one),

    "_plus" = (if R::hasProp(GcdDomain) then
	proc(x,y) local g, d; begin
	    case args(0)
	    of 1 do return(x);
	    of 2 do
		if map({args()}, domtype) <> {this} then return(FAIL) end_if;
		g:= R::gcd(extop(x,2), extop(y,2));
		d:= R::divex(extop(x,2), g);
		return(this::normalize(
		    R::_plus(R::_mult(extop(x,1),
				      R::divex(extop(y,2), g)),
			     R::_mult(extop(y,1), d)),
		    R::_mult(extop(y,2), d)));
	    end_case;
	    g:= args(0) div 2;
	    d:= _plus(args(1..g));
	    g:= _plus(args((g+1)..args(0)));
	    d + g
	end_proc
    else
	proc(x,y) local g, i; begin
	    case args(0)
	    of 1 do return(x);
	    of 2 do
		if map({args()}, domtype) <> {this} then return(FAIL) end_if;
		return(this::normalize(
		    R::_plus(R::_mult(extop(x,1), extop(y,2)),
			     R::_mult(extop(y,1), extop(x,2))),
		    R::_mult(extop(x,2), extop(y,2))));
	    end_case;
	    g:= args(0) div 2;
	    d:= _plus(args(1..g));
	    g:= _plus(args((g+1)..args(0)));
	    d + g
	end_proc
    end_if),

    "negate" = proc(x) begin
	this::normalizePrime(R::negate(extop(x,1)), extop(x,2))
    end_proc,

    "_mult" = (if R::hasProp(GcdDomain) then
	if R::hasProp(systemRep) then
	
	proc(x,y) local p, q; begin
	    case args(0)
	    of 2 do
		if domtype(y) <> this then
		    if domtype(y) = DOM_INT then
		    	return(this::intmult(args()))
		    elif testtype(y, R) then
		        return(this::_mult(x, this::convert(y)))
		    else
		        return((domtype(y))::_mult(x, y))
		    end_if;
		elif domtype(x) <> this then
		    if domtype(x) = DOM_INT then
		    	return(this::intmult(y, x))
		    elif testtype(x, R) then
		        return(this::_mult(this::convert(x), y))
		    else
		        return(FAIL)
		    end_if;
		end_if;
		p:= R::gcd(extop(x,1), extop(y,2));
		q:= R::gcd(extop(y,1), extop(x,2));
		return(this::normalizePrime(
		    R::_mult(R::divex(extop(x,1), p),
			     R::divex(extop(y,1), q)),
		    R::_mult(R::divex(extop(x,2), q),
			     R::divex(extop(y,2), p))));
	    of 1 do return(x);
	    end_case;
	    p:= args(0) div 2;
	    _mult(args(q) $ q=1..p);
	    _mult(args(q) $ q=(p+1)..args(0));
	    _mult(%1, %2)
	end_proc
	
    	else
	
	proc(x,y) local p, q; begin
	    case args(0)
	    of 2 do
		if domtype(y) <> this then
		    case domtype(y)
		    of DOM_INT do
		    	return(this::intmult(args()));
		    of R do
		        return(this::_mult(x, this::normalize(y, R::one)));
		    end_case;
		    return(FAIL);
		elif domtype(x) <> this then
		    return(this::_mult(y,x));
		end_if;
		p:= R::gcd(extop(x,1), extop(y,2));
		q:= R::gcd(extop(y,1), extop(x,2));
		return(this::normalizePrime(
		    R::_mult(R::divex(extop(x,1), p),
			     R::divex(extop(y,1), q)),
		    R::_mult(R::divex(extop(x,2), q),
			     R::divex(extop(y,2), p))));
	    of 1 do return(x);
	    end_case;
	    p:= args(0) div 2;
	    _mult(args(q) $ q=1..p);
	    _mult(args(q) $ q=(p+1)..args(0));
	    _mult(%1, %2)
	end_proc
	
    	end_if
    else
	if R::hasProp(systemRep) then
	
	proc(x,y) local p, q; begin
	    case args(0)
	    of 2 do
		if domtype(y) <> this then
		    if domtype(y) = DOM_INT then
		    	return(this::intmult(args()))
		    elif testtype(y, R) then
		        return(this::_mult(x, this::convert(y)))
		    end_if;
		    return(FAIL);
		elif domtype(x) <> this then
		    return(this::_mult(y,x));
		end_if;
		return(this::normalize(
			R::_mult(extop(args(1),1), extop(args(2),1)),
		        R::_mult(extop(args(1),2), extop(args(2),2))));
	    of 1 do return(x);
	    end_case;
	    p:= args(0) div 2;
	    _mult(args(q) $ q=1..p);
	    _mult(args(q) $ q=(p+1)..args(0));
	    _mult(%1, %2)
	end_proc
	
    	else
    	
	proc(x,y) local p, q; begin
	    case args(0)
	    of 2 do
		if domtype(y) <> this then
		    case domtype(y)
		    of DOM_INT do
		    	return(this::intmult(args()));
		    of R do
		        return(this::_mult(x, this::normalize(y, R::one)));
		    end_case;
		    return(FAIL);
		elif domtype(x) <> this then
		    return(this::_mult(y,x));
		end_if;
		return(this::normalize(
			R::_mult(extop(args(1),1), extop(args(2),1)),
		        R::_mult(extop(args(1),2), extop(args(2),2))));
	    of 1 do return(x);
	    end_case;
	    p:= args(0) div 2;
	    _mult(args(q) $ q=1..p);
	    _mult(args(q) $ q=(p+1)..args(0));
	    _mult(%1, %2)
	end_proc

    	end_if
    end_if),

    "invert" = proc(x) begin
	if R::iszero(extop(x,1)) then error("division by zero") end_if;
	this::normalizePrime(extop(x,2), extop(x,1))
    end_proc,

    "intmult" = proc(x,i) begin
	this::normalize(R::intmult(extop(x,1),i), extop(x,2))
    end_proc,

    "_power" = proc(x,n) begin
	if domtype(n) = DOM_INT then
	    if n > 0 then
		this::normalizePrime(R::_power(extop(x,1), n),
				     R::_power(extop(x,2), n))
	    elif n = 0 then
		this::one
	    else
		if R::iszero(extop(x,1)) then
		    error("division by zero")
		end_if;
		this::normalizePrime(R::_power(extop(x,2), -n),
				     R::_power(extop(x,1), -n))
	    end_if
	else
	    error("no integer power")
	end_if
    end_proc,

    "retract" = (if R::hasProp(GcdDomain) then
	if R::hasProp(canonicalUnitNormal) then
	    proc(x) begin
		if R::equal(extop(x,2), R::one) then extop(x,1)
		else FAIL end_if
	    end_proc
	else
	    proc(x) local z; begin
		z:= R::invert(extop(x,2));
		if z = FAIL then FAIL else R::_mult(extop(x,1), z) end_if
	    end_proc
	end_if
    else
	proc(x) begin R::divex(extop(x,1), extop(x,2)) end_proc
    end_if),

    "D" = ( if R::hasProp(DifferentialRing) then
	proc(x) begin
	    if args(0) <> 1 then error("wrong no of args") end_if;
	    this::normalize(
		R::minus(
		    R::_mult(R::D(extop(x,1)), extop(x,2)),
		    R::_mult(extop(x,1), R::D(extop(x,2)))),
		R::_power(extop(x,2),2))
	end_proc
    elif R::hasProp(PartialDifferentialRing) then
	proc(a,x) begin
	    if args(0) <> 2 then error("wrong no of args") end_if;
	    this::normalize(
		R::minus(
		    R::_mult(R::D(a,extop(x,1)), extop(x,2)),
		    R::_mult(extop(x,1), R::D(a,extop(x,2)))),
		R::_power(extop(x,2),2))
	end_proc
    end_if ),
    
    "random" = fun((
        R::random();
        if R::iszero(%) then this::zero
        else this::normalize(R::random(), %)
        end_if
    ))

):

# end of file #
