# $Date: 1995/07/11 10:00:25 $ $Author: frankp $ $Revision: 1.19.2.3 $
#
#++
IntegerMod -- domain constructor for the residue class rings Z/nZ

IntegerMod(n)

n - integer > 1

IntegerMod(n) creates the residue class ring (or field) Z/nZ.
An element is represented as a domain element with operands:

0 - domain IntegerMod(n)
1 - integer of {0,...,n-1} representing the residue class

++#

IntegerMod:= DomainConstructor(
    IntegerMod,
    [ Mod ],
    [ ],
    (if args(0) <> 1 then error("wrong no of args") end_if;
     if domtype(Mod) <> DOM_INT then
	 error("argument must be integer")
     end_if;
     if Mod < 2 then
	 error("modulus must be > 1")
     end_if),
    BaseDomain,
    [ (if isprime(Mod) then Field else CommutativeRing end_if) ],
    [ canonicalRep ],

    "characteristic" = Mod,
    
    "zero" = new(this, 0),

    "one" = new(this, 1),

    "iszero" = fun( iszero(extop(args(1),1)) ),

    "convert" = fun((
	case domtype(args(1))
	of this do return(args(1));
	of DOM_INT do return(new(this, args(1) mod Mod));
	of DOM_RAT do return(this::divex(this::new(op(args(1),1)),
					 this::new(op(args(1),2))));
	end_case;
        FAIL
    )),

    "convert_to" = fun((
	case args(2)
	of DOM_INT do
	of Integer do return(extop(args(1),1));
	of this do return(args(1));
	end_case;
	FAIL
    )),

    "expr" = fun( extop(args(1),1) ),

    "print" = fun( hold(_mod)(extop(args(1),1), Mod) ),

    "_plus" = fun((
	if map({args()}, domtype) <> {this} then return(FAIL) end_if;
	new(this, _plus(map(args(), extop, 1)) mod Mod)
    )),

    "minus" = fun(
	new(this, (extop(args(1),1) - extop(args(2),1)) mod Mod)
    ),

    "_mult" = fun((
    	if args(0) = 2 then
	    if domtype(args(2)) <> this then
	    	if domtype(args(2)) = DOM_INT then
	    	    this::intmult(args())
	    	else
	    	    (domtype(args(2)))::_mult(args())
	    	end_if
	    elif domtype(args(1)) <> this then
	    	if domtype(args(1)) = DOM_INT then
	    	    this::intmult(args(2), args(1))
	    	else
	    	    FAIL
	    	end_if
	    else
	        new(this, _mult(map(args(), extop, 1)) mod Mod)
	    end_if
    	elif args(0) = 1 then
    	    args(1)
    	else
    	    this::_mult(args(1), _mult(args(2..args(0))))
    	end_if
    )),

    "_power" = (if isprime(Mod) then
	fun((
	    if args(2) < 0 then
		new(this, powermod((1 / extop(args(1),1)) mod Mod, -args(2), Mod))
	    else
		new(this, powermod(extop(args(1),1), args(2), Mod))
	    end_if
	))
    else
	fun(
	    new(this, powermod(extop(args(1),1), args(2), Mod))
	)
    end_if),

    "negate" = fun(
	new(this, (-extop(args(1),1)) mod Mod)
    ),

    "intmult" = fun(
	new(this, (extop(args(1),1) * args(2)) mod Mod)
    ),

    "invert" = (if isprime(Mod) then
	fun(
	    new(this, (1 / extop(args(1),1)) mod Mod)
	)
    else
	fun((
	    if igcd(extop(args(1),1), Mod) = 1 then
		new(this, (1 / extop(args(1),1)) mod Mod)
	    else
		FAIL
	    end_if
	))
    end_if),

    "divex" = (if isprime(Mod) then
	fun(
	    new(this, (extop(args(1),1) / extop(args(2),1)) mod Mod)
	)
    else
	fun((
	    if igcd(extop(args(2),1), Mod) = 1 then
		new(this, (extop(args(1),1) / extop(args(2),1)) mod Mod)
	    else
		FAIL
	    end_if
	))
    end_if),

    "TeX" = fun(
	expr2text(extop(args(1),1))." \\mbox{mod} ".expr2text(Mod)
    ),

    "random" = eval( subsop(hold(fun(new(this, r()))),
    		      [1,2,0]=random(Mod)) )
):

# end of file #
