# $Date: 1995/06/28 10:01:59 $ $Author: kg $ $Revision: 1.18.2.1 $
#
#++
Numerical -- the domain of numbers

A number is represented by an expression of type DOM_INT, DOM_RAT,
DOM_FLOAT or DOM_COMPLEX.

The domain has category 'Field', which is very optimistic (indeed
false, because for example bool(1.0 = float(3) / float(3)) returns
FALSE). The category is assumed only because of pragmatism.

Methods:-
testtype(x,D)  - returns TRUE if x is of a numerical type
norm(x)        - returns the norm of x, ie., abs(x)
D(l,x)         - returns the derivation of x, ie., 0
convert(x)     - returns the value of x converted to Numerical
++#

Numerical:= DomainConstructor(

    Numerical,
    [ ],
    [ ],
    NIL,
    ArithmeticalExpression,
    [ Field, DifferentialRing ],
    [ canonicalRep, systemRep ],

    "characteristic" = 0,
    
    "testtype" = fun((
	if contains({DOM_INT, DOM_RAT, DOM_FLOAT, DOM_COMPLEX}, domtype(args(1))) then
	    TRUE 
	elif contains({DOM_FLOAT, DOM_COMPLEX}, domtype(float(args(1)))) then
	    TRUE
	else
	    FAIL 
	end_if
    )),

    "norm" = abs,

    "D" = D,

    "diff" = diff,

    "convert" = fun((
        if contains({DOM_INT, DOM_RAT, DOM_FLOAT, DOM_COMPLEX}, domtype(args(1))) then 
            args(1)
        else
            float(args(1));
            if contains({DOM_FLOAT, DOM_COMPLEX}, domtype(%)) then
                %
            else
                FAIL
            end_if
        end_if
    )),

    "convert_to" = proc(x,T) local Tx; begin
	Tx:= domtype(x);
        if not contains({DOM_INT, DOM_RAT, DOM_FLOAT, DOM_COMPLEX}, Tx)
        then
	    FAIL
        else
	    case T
	    of DOM_INT do
	    of DOM_RAT do
	    of DOM_COMPLEX do
		if Tx = T then x else FAIL end_if;
		break;
	    of DOM_FLOAT do
	    of Float do
		x:= float(x);
		if domtype(x) = DOM_FLOAT then x else FAIL end_if;
		break;
	    of Numerical do
		x;
		break;
	    of Integer do
		if Tx = DOM_INT then x else FAIL end_if;
		break;
	    of Rational do
		if contains({DOM_INT, DOM_RAT}, Tx) then x else FAIL end_if;
		break;
	    otherwise FAIL;
	    end_case
	end_if
    end_proc,
    
    "random" = fun(tan(float(PI) * (random()/(10.0^12) - 0.5)) +
    		   tan(float(PI) * (random()/(10.0^12) - 0.5)) * I)

)():

