# $Date: 1995/05/17 15:58:15 $ $Author: kg $ $Revision: 1.6 $ #
#++
Product -- the domain constructor of homogeneous finite products

Product(S [,n])

S - set
n - positive integer (optional, default is 1)

A homogeneous finite product is a n-fold product of identical sets S.

Entries:-
card                - the dimension n

Methods:-
map(p,f,...)        - maps f(p.i,...) to each component of p
zip(p,q,f)          - maps f(p.i,q.i) to each corresponding component pair of p and q
mapCanFail(p,f,...) - like map but returns FAIL if one call of f returns FAIL
zipCanFail(p,q,f)   - like zip but returns FAIL if one call of f returns FAIL
testEach(p,f,...)   - returns TRUE if f(p.i,...) returns TRUE for each component of p
testOne(p,f,...)    - returns TRUE if f(p.i,...) returns TRUE for one component of p
_index(p,i)         - returns the i-th component of p
set_index(p,i,v)    - changes the i-th component of p to v
nops(p)             - returns n
op(p)               - returns the sequence (p[1],...p[n])
op(p,i)             - returns p[i]
subsop(p,i=v)       - changes the i-th element op p to v
subs(p,x=y)         - substitutes x by y in each element of p
++#

Product:= DomainConstructor(
    Product,
    [ Set, Dimen ],
    [ ],
    ( if args(0) = 1 then Dimen:= 1
      elif args(0) = 2 then
      	  if not testtype(Dimen, Type::PosInt) then
      	      error("illegal dimension")
      	  end_if
      else error("wrong no of args") end_if;
      if Set::hasProp(SetCat) <> TRUE then
      	  error("not a set")
      end_if
    ),
    BaseDomain,
    [ HomogeneousFiniteProductCat(Set) ],
    [ (if Set::hasProp(canonicalRep) then canonicalRep end_if),
      (if Set::hasProp(AbelianMonoid) then
           if Set::hasProp(normalRep) then normalRep end_if
       end_if)
    ],    
   
    "card" = Dimen,
    
    "convert" = (if Dimen = 1 then
        proc(e) begin
            if args(0) <> 1 then return(FAIL) end_if;
            case domtype(e)
            of this do return(e);
            of DOM_LIST do e:= e[1]; #fall through#
            otherwise e:= Set::convert(e);
            end_case;
            if e = FAIL then FAIL else new(this, e) end_if
        end_proc
    else
	proc(l) begin
	    if args(0) = 1 then
	    	case domtype(l)
	    	of this do return(l);
	    	of DOM_LIST do break;
	    	otherwise return(FAIL);
	    	end_case;
	    elif args(0) = Dimen then
	    	l:= [ args() ];
	    else
	    	return(FAIL)
	    end_if;
	    l:= map(l, Set::convert);
	    if contains(l, FAIL) = 0 then new(this, l) else FAIL end_if
	end_proc
    end_if),
    
    "expr" = (if Dimen = 1 then
    	fun(Set::expr(extop(args(1),1)))
    else
    	fun(map(extop(args(1),1), Set::expr))
    end_if),

    "equal" = (if this::hasProp(canonicalRep) then
	bool @ _equal
    elif Dimen = 1 then
    	fun(Set::equal(extop(args(1),1), extop(args(2),1)))
    else
    	proc(x,y) local i; begin
    	    x:= extop(x,1); y:= extop(y,1);
    	    for i from 1 to Dimen do
    	    	if not Set::equal(x[i], y[i]) then return(FALSE) end_if
    	    end_for;
    	    TRUE
    	end_proc
    end_if),

    "map" = (if Dimen = 1 then
    	fun(new(this, args(2)(extop(args(1),1), args(i) $ hold(i)=3..args(0))))
    else
    	fun(new(this, map(extop(args(1),1), args(i) $ hold(i)=2..args(0))))
    end_if),
    
    "zip" = (if Dimen = 1 then
    	fun(new(this, args(3)(extop(args(1),1), extop(args(2),1))))
    else
    	fun(new(this, zip(extop(args(1),1), extop(args(2),1), args(3))))
    end_if),

    "mapCanFail" = (if Dimen = 1 then
    	proc(x,f) local i; begin
    	    x:= f(extop(x,1), args(i) $ i=3..args(0));
    	    if x = FAIL then FAIL else new(this, x) end_if
    	end_proc
    else
    	proc(x,f) local e, l, a; begin
    	    a:= args(e) $ e=3..args(0);
    	    l:= [];
    	    for e in extop(x,1) do
    	    	e:= f(e, a);
    	    	if e = FAIL then return(FAIL) end_if;
    	    	l:= append(l, e)
    	    end_for;
    	    new(this, l)
    	end_proc
    end_if),
    
    "zipCanFail" = (if Dimen = 1 then
    	proc(x,y,f) begin
    	    x:= f(extop(x,1), extop(y,1));
    	    if x = FAIL then FAIL else new(this, x) end_if
    	end_proc
    else
    	proc(x,y,f) local e, l, i; begin
    	    x:= extop(x,1);
    	    y:= extop(y,1);
    	    l:= [];
    	    for i from 1 to Dimen do
    	    	e:= f(x[i], y[i]);
    	    	if e = FAIL then return(FAIL) end_if;
    	    	l:= append(l, e)
    	    end_for;
    	    new(this, l)
    	end_proc
    end_if),

    "testEach" = (if Dimen = 1 then
    	fun(args(2)(extop(args(1),1), args(i) $ hold(i)=3..args(0)))
    else
    	proc(x,f) local e, a; begin
    	    a:= args(e) $ e=3..args(0);
    	    for e in extop(x,1) do
    	    	if not f(e,a) then return(FALSE) end_if
    	    end_for;
    	    TRUE
    	end_proc
    end_if),

    "testOne" = (if Dimen = 1 then
    	this::testEach
    else
    	proc(x,f) local e, a; begin
    	    a:= args(e) $ e=3..args(0);
    	    for e in extop(x,1) do
    	    	if f(e,a) then return(TRUE) end_if
    	    end_for;
    	    FALSE
    	end_proc
    end_if),

    "op" = (if Dimen = 1 then
    	fun(extop(args(1),1))
    else
    	fun((
    	    if args(0) = 1 then op(extop(args(1),1))
    	    else extop(args(1),1)[args(2)] end_if
    	))
    end_if),

    "_index" = (if Dimen = 1 then
    	fun(extop(args(1),1))
    else
    	fun(extop(args(1),1)[args(2)])
    end_if),
    
    "set_index" = (if Dimen = 1 then
    	fun(new(this, args(args(0))))
    else
    	fun(new(this, subsop(extop(args(1),1), args(2)=args(args(0)))))
    end_if),
    
    "_less" = (if Set::hasProp(OrderedSet) then
    	if Dimen = 1 then
    	    fun(Set::_less(extop(args(1),1), extop(args(2),1)))
    	else
    	    # order lexicographically #
    	    proc(x,y) local i; begin
    	    	x:= extop(x,1);
    	    	y:= extop(y,1);
    	    	for i from 1 to Dimen do
    	    	    if not Set::equal(x[i], y[i]) then
    	    	    	return(bool(Set::_less(x[i], y[i])))
    	    	    end_if
    	    	end_for;
    	    	FALSE
    	    end_proc
    	end_if
    end_if),

    "subs" = (if Dimen = 1 then
        fun(new(this, subs(extop(args(1),1), args(2))))
    else
        fun(new(this, map(extop(args(1),1), subs, args(2))))
    end_if),
    
    "subsop" = (if Dimen = 1 then
    	fun(new(this, args(3)))
    else
        fun(new(this, subsop(extop(args(1),1), args(2)=args(3))))
    end_if),
    
    "_plus" = (if Set::hasProp(AbelianSemiGroup) then
	if Dimen = 1 then
	    fun((if map({args()}, domtype) <> {this} then return(FAIL) end_if;
	         new(this, Set::_plus(extop(args(i),1) $ hold(i)=1..args(0)))))
	else
	    fun((
	    	case args(0)
	    	of 2 do
	    	    if map({args()}, domtype) <> {this} then return(FAIL) end_if;
	    	    new(this, zip(extop(args(1),1), extop(args(2),1), Set::_plus));
		    break;
	    	of 1 do args(1); break;
		otherwise
	    	    _plus(args(i) $ hold(i)=1..(args(0) div 2));
	    	    _plus(args(i) $ hold(i)=((args(0) div 2)+1)..args(0));
	    	    _plus(%1 + %2)
	    	end_case
	    ))
	end_if
    end_if),
    
    "intmult" = (if Set::hasProp(AbelianSemiGroup) then
	if Dimen = 1 then
	    fun(new(this, Set::intmult(extop(args(1),1), args(2))))
	else
	    fun(new(this, map(extop(args(1),1), Set::intmult, args(2))))
	end_if
    end_if),
    
    "zero" = (if Set::hasProp(AbelianMonoid) then
	if Dimen = 1 then
	    new(this, Set::zero)
	else
	    new(this, [ Set::zero $ Dimen ])
	end_if
    end_if),
    
    "iszero" = (if Set::hasProp(AbelianMonoid) then
	if Dimen = 1 then
	    fun(Set::iszero(extop(args(1),1)))
	else
	    proc(x) local i; begin
	    	for i in extop(x,1) do 
	    	    if not Set::iszero(i) then return(FALSE) end_if 
	    	end_for;
	    	TRUE
	    end_proc
	end_if
    end_if),

    "minus" = (if Set::hasProp(AbelianGroup) then
	if Dimen = 1 then
	    fun(new(this, Set::minus(extop(args(1),1), extop(args(2),1))))
	else
	    fun(new(this, zip(extop(args(1),1), extop(args(2),1), Set::minus)))
	end_if
    elif Set::hasProp(CancellationAbelianMonoid) then
	if Dimen = 1 then
	    proc(x,y) begin
	    	x:= Set::minus(extop(x,1), extop(y,1));
	    	if x = FAIL then FAIL else new(this, x) end_if
	    end_proc
	else
	    proc(x,y) begin
	    	x:= zip(extop(x,1), extop(y,1), Set::minus);
	    	if contains(x,FAIL) = 0 then new(this, x) else FAIL end_if
	    end_proc
	end_if
    end_if),
    
    "negate" = (if Set::hasProp(AbelianGroup) then
	if Dimen = 1 then
	    fun(new(this, Set::negate(extop(args(1),1))))
	else
	    fun(new(this, map(extop(args(1),1), Set::negate)))
	end_if
    elif Set::hasProp(CancellationAbelianMonoid) then
	if Dimen = 1 then
	    proc(x) begin
	    	x:= Set::negate(extop(x,1));
	    	if x = FAIL then FAIL else new(this, x) end_if
	    end_proc
	else
	    proc(x) begin
	    	x:= map(extop(x,1), Set::negate);
	    	if contains(x,FAIL) = 0 then new(this, x) else FAIL end_if
	    end_proc
	end_if
    end_if),
    
    "_mult" = (if Set::hasProp(SemiGroup) then
    	if Dimen = 1 then
    	    if Set::hasProp(systemRep) then
    	    	fun((
    	    	    if args(0) = 2 then
    	    	        if domtype(args(2)) <> this then
    	    	            Set::_mult(extop(args(1),1), args(2));
    	    	            if testtype(%, Set) then new(this, %) else FAIL end_if;
    	    	        elif domtype(args(1)) <> this then
    	    	            Set::_mult(args(1), extop(args(2),1));
    	    	            if testtype(%, Set) then new(this, %) else FAIL end_if;
    	    	        else
    	    	            new(this, Set::_mult(extop(args(1),1), extop(args(2),1)))
    	    	        end_if
    	    	    elif args(0) = 1 then
    	    	    	args(1)
    	    	    else
    	    	    	_mult(args(i) $ hold(i)=1..(args(0) div 2));
    	    	    	_mult(args(i) $ hold(i)=((args(0) div 2)+1)..args(0));
    	    	    	_mult(%1, %2)
    	    	    end_if
    	    	))
	    else
    	    	fun((
    	    	    if args(0) = 2 then
    	    	        if domtype(args(2)) <> this then
    	    	            Set::_mult(extop(args(1),1), args(2));
    	    	            if domtype(%) = Set then new(this, %) else FAIL end_if;
    	    	        elif domtype(args(1)) <> this then
    	    	            Set::_mult(args(1), extop(args(2),1));
    	    	            if domtype(%) = Set then new(this, %) else FAIL end_if;
    	    	        else
    	    	            new(this, Set::_mult(extop(args(1),1), extop(args(2),1)))
    	    	        end_if
    	    	    elif args(0) = 1 then
    	    	    	args(1)
    	    	    else
    	    	    	_mult(args(i) $ hold(i)=1..(args(0) div 2));
    	    	    	_mult(args(i) $ hold(i)=((args(0) div 2)+1)..args(0));
    	    	    	_mult(%1, %2)
    	    	    end_if
    	    	))
	    end_if
	else
    	    if Set::hasProp(systemRep) then
    	    	fun((
    	    	    if args(0) = 2 then
    	    	        if domtype(args(2)) <> this then
    	    	            map(extop(args(1),1), Set::_mult, args(2));
    	    	            if testtype(%, Type::ListOf(Set)) then new(this, %)
    	    	            else FAIL end_if
    	    	        elif domtype(args(1)) <> this then
    	    	            zip([args(1) $ Dimen], extop(args(2),1), Set::_mult);
    	    	            if testtype(%, Type::ListOf(Set)) then new(this, %)
    	    	            else FAIL end_if
    	    	        else
    	    	            new(this, zip(extop(args(1),1), extop(args(2),1), Set::_mult))
    	    	        end_if
    	    	    elif args(0) = 1 then
    	    	    	args(1)
    	    	    else
    	    	    	_mult(args(i) $ hold(i)=1..(args(0) div 2));
    	    	    	_mult(args(i) $ hold(i)=((args(0) div 2)+1)..args(0));
    	    	    	_mult(%1, %2)
    	    	    end_if
    	    	))
    	    else
    	    	fun((
    	    	    if args(0) = 2 then
    	    	        if domtype(args(2)) <> this then
    	    	            map(extop(args(1),1), Set::_mult, args(2));
    	    	            if {op(map(%, domtype))} = {Set} then new(this, %)
    	    	            else FAIL end_if
    	    	        elif domtype(args(1)) <> this then
    	    	            zip([args(1) $ Dimen], extop(args(2),1), Set::_mult);
    	    	            if {op(map(%, domtype))} = {Set} then new(this, %)
    	    	            else FAIL end_if
    	    	        else
    	    	            new(this, zip(extop(args(1),1), extop(args(2),1), Set::_mult))
    	    	        end_if
    	    	    elif args(0) = 1 then
    	    	    	args(1)
    	    	    else
    	    	    	_mult(args(i) $ hold(i)=1..(args(0) div 2));
    	    	    	_mult(args(i) $ hold(i)=((args(0) div 2)+1)..args(0));
    	    	    	_mult(%1, %2)
    	    	    end_if
    	    	))
    	    end_if
    	end_if
    end_if),
    
    "_power" = (if Set::hasProp(SemiGroup) then
	if Dimen = 1 then
	    fun(new(this, Set::_power(extop(args(1),1), args(2))))
	else
	    fun(new(this, map(extop(args(1),1), Set::_power, args(2))))
	end_if
    end_if),
    
    "one" = (if Set::hasProp(Monoid) then
	if Dimen = 1 then
	    new(this, Set::one)
	else
	    new(this, [ Set::one $ Dimen ])
	end_if
    end_if),
    
    "invert" = (if Set::hasProp(Group) then
	if Dimen = 1 then
	    fun(new(this, Set::invert(extop(args(1),1))))
	else
	    fun(new(this, map(extop(args(1),1), Set::invert)))
	end_if
    elif Set::hasProp(Monoid) then
	if Dimen = 1 then
	    proc(x) begin
	    	x:= Set::invert(extop(x,1));
	    	if x = FAIL then FAIL else new(this, x) end_if
	    end_proc
	else
	    proc(x) begin
	    	x:= map(extop(x,1), Set::invert);
	    	if contains(x,FAIL) = 0 then new(this, x) else FAIL end_if
	    end_proc
	end_if
    end_if),
    
    "divex" = (if Set::hasProp(Group) then
	if Dimen = 1 then
	    fun(new(this, Set::divex(extop(args(1),1), extop(args(2),1))))
	else
	    fun(new(this, zip(extop(args(1),1), extop(args(2),1), Set::divex)))
	end_if
    end_if),
    
    "D" = (if Set::hasProp(PartialDifferentialRing) then
	if Dimen = 1 then
	    fun(new(this,
	    	    (if args(0) = 1 then Set::D(extop(args(1),1))
	    	     else Set::D(args(1), extop(args(2),1)) end_if)))
	else
	    fun(new(this,
	    	    (if args(0) = 1 then map(extop(args(1),1), Set::D)
	    	     else map(extop(args(2),1), 
	    	     	      eval(subsop(hold(fun(Set::D(A, args(1)))), [1,1]=args(1))))
	    	     end_if)))
	end_if
    end_if),
    
    "random" = (if Dimen = 1 then
        fun(new(this, Set::random()))
    else
        subsop(hold(fun(new(this, l))), [1,2] = [ hold(Set::random()) $ Dimen ])
    end_if)

):
