# $Date: 1995/06/28 10:02:03 $ $Author: kg $ $Revision: 1.16.2.1 $ #
#++
Rational -- the domain of rational numbers

A rational number is represented by an expression of type DOM_INT
or DOM_RAT.

Methods:-
convert(x)         - returns the value of x converted to Rational
numer(x)	   - returns the numerator of x
denom(x)	   - returns the denominator of x
retract(x)	   - returns x if it is an integer and FAIL otherwise
testtype(x,D)      - returns TRUE if x is of type DOM_INT or DOM_RAT
min(x,...)	   - returns the minimal argument
max(x,...)	   - returns the maximal argument
++#

Rational:= DomainConstructor(

    Rational,
    [ ],
    [ ],
    NIL,
    Numerical,
    [ QuotientField(Integer), DifferentialRing, OrderedSet ],
    [ canonicalRep, systemRep, canonicalOrder ],

    "testtype" = fun((
	if contains({DOM_INT, DOM_RAT}, domtype(args(1))) then
	    TRUE
	else
	    FAIL
	end_if
    )),

    "numer" = fun((
	if domtype(args(1)) = DOM_RAT then op(args(1),1) else args(1) end_if
    )),

    "denom" = fun((
	if domtype(args(1)) = DOM_RAT then op(args(1),2) else 1 end_if
    )),

    "retract" = fun((
	if domtype(args(1)) = DOM_INT then args(1) else FAIL end_if
    )),

    "convert" = fun((
       if contains({DOM_INT, DOM_RAT}, domtype(args(1))) then
          args(1)
       else
          FAIL
       end_if
    )),

    "convert_to" = fun((
	if not contains({DOM_INT, DOM_RAT}, domtype(args(1))) then FAIL else
	    case args(2)
	    of Rational do
	    of Numerical do
		args(1);
		break;
	    of DOM_RAT do
		if domtype(args(1)) = DOM_RAT then args(1) else FAIL end_if;
		break;
	    of Integer do
	    of DOM_INT do
		if domtype(args(1)) = DOM_INT then args(1) else FAIL end_if;
		break;
	    of DOM_FLOAT do
	    of Float do
		float(args(1));
		break;
	    otherwise FAIL;
	    end_case
	end_if
    )),

    "min" = min,

    "max" = max,
    
    "random" = fun((
        Integer::random();
        if % = 0 then 0 else Integer::random() / % end_if
    ))

)():

