# $Date: 1995/05/17 08:45:30 $ $Author: kg $ $Revision: 1.6 $ #

#++
RingAdj -- domain constructor for

RingAdj(R,p)

R - Domain that represents a Ring
p - Minimal Polynom of the adjungated element

RingAdj(R,p) create the Ring R[e], where p is the minimal polynomial
of e.

++#


RingAdj :=
DomainConstructor(
   # Name des Domains #
   RingAdj,

   # Parameter #
   [R , p],
   [ ],

   # Parameterpr"ufung #
   ( if args(0) <> 2 then error("wrong no of args") end_if;
     if not R::hasProp(Ring) then
        error("Wrong Argument")
     end_if ;
     if domtype(p) <> DOM_POLY then
        error("Wrong type of argument") ;
     end_if ;
     if op(p, 3) <> R then
        error("Wrong polynomial") ;
     end_if) ,

   # Super-Domains #
   BaseDomain,

   # Kategorien #
   [ (if R::hasProp(Field) then
         Field
       else
         Ring
      end_if) ],

   # Axiome #
   [ ],

   # Eintraege #
   "_plus" = proc(x)
                local i ;
             begin
                x := extop(x, 1) ;
                for i from 2 to args(0) do
                   x := x+extop(args(i), 1) ;
                end_for ;
                new( this, x) ;
             end_proc ,

   "negate" = proc(x)
              begin
                 new( this, -extop(x, 1) ) ;
              end_proc ,

   "subtract" = proc(x,y)
                begin
                   new( this, extop(x,1) -extop(y,1) ) ;
                end_proc ,

   "zero" = new( this, poly( R::zero, [op(p,[2,1])], R ) ) ,

   "iszero" = proc(x)
             begin
                bool( x = this::zero )
             end_proc,

   "_mult" = proc(x)
                local i ;
             begin
                x := extop(x, 1) ;
                for i from 2 to args(0) do
                   x := divide( x * extop(args(i),1) , p , Rem ) ;
                end_for ;
                new( this, x ) ;
             end_proc ,

   "intmult" = proc(x, i)
               begin
                  new( this, extop(x, 1) * i ) ;
               end_proc ,

   "invert" = proc(x)
                 local a,q,c,c1,c2,d,d1,d2,r,r1,r2,v,l;
              begin
                 a := extop(x,1) ;
                 d := p ;
                 v:= op(a,2);
                 c:= multcoeffs(a,R::invert(lcoeff(a)));
                 c1:= poly(R::one,v,R);
                 d1:= poly(R::zero,v,R);
                 c2:= poly(R::zero,v,R);
                 d2:= poly(R::one,v,R);
                 while not iszero(d) do
                   q:= divide(c,d); r:= op(q,2);
                   q:= op(q,1);
                   r1:= c1-q*d1; r2:= c2-q*d2;
                   c:= d; c1:= d1; c2:= d2;
                   d:= r; d1:= r1; d2:= r2;
                 end_while;
                 l:= R::invert(lcoeff(c));
                 if degree(c) > 0 then
                    FAIL
                  else
                    new(this, multcoeffs(c1,l*R::invert(lcoeff(a)))) ;
                 end_if
              end_proc ,

   "one" = new( this, poly( R::one, [op(p,[2,1])], R ) ) ,

   "new" = proc(x)
              name RingAdj::new ;
           begin
              if args(0) <> 1 then
                 error("Wrong number of arguments") ;
              end_if ;
              if domtype(x) = DOM_POLY then
                 if testargs() then
                    if nops(op(x, 2)) <> 1 or op(x, [2,1]) <> op(p, [2,1]) then
                       error("Wrong type of parameter")
                     end_if
                 end_if ;
                 x := poly(x, R) ;
                 if x=FAIL then
                    error("Wrong type of argument") ;
                 end_if ;
                 new( this, divide( x, p, Rem ) ) ;
               else
                 x := poly(x, [op(p, [2,1])], R ) ;
                 if x <> FAIL then
                    new( this, x ) ;
                  else
                    error("Wrong type of argument")
                 end_if
              end_if
           end_proc ,

   "convert" = proc(x)
                  name RingAdj::convert ;
               begin
                  if args(0) <> 1 then
                     error("Wrong number of arguments") ;
                  end_if ;
                  if domtype(x) = this then
                     return(x) ;
                  end_if ;
                  if domtype(x) = DOM_POLY then
                     if testargs() then 
                        if nops(op(x, 2)) <> 1 or op(x, [2,1]) <> op(p, [2,1]) then
                           FAIL
                         end_if 
                     end_if ; 

                     x := poly(x, R) ;
                     if x=FAIL then
                        FAIL
                     end_if ;
                     new( this, divide ( x, p, Rem ) ) ;
                   else
                     x := poly(x, [op(p, [2,1])], R ) ; 
                     if x <> FAIL then 
                        new( this, x ) ;
                      else 
                        FAIL
                     end_if ;
                  end_if
               end_proc,

   "expr" = proc(x)
            begin
               expr(extop(x, 1))
            end_proc,

   "print" = proc(x)
             begin
                expr2text(extop(x,1))." mod ".expr2text(p) ;
             end_proc
) :

# end of file #
