# $Date: 1995/06/23 08:26:03 $ $ Author: yuan $ #

#--
faclib::binomial -- return the factorization of binomial in Z, the algorithm 
                    comes from Hans Riesel, Prime numbers and computer methods 
                    for factorization, page 318-323, Rirkhaeuser Boston, Inc., 
                    1985 and E. J. Barbeau, Polynomials, Chapter 3, Springer
                    Verlag New York, Inc., 1989, output is a list of factors in
                    polynomial form.

faclib::binomial(pa,pb)
pa+pb - the input binomial in Z

faclib::sbinomial -- return the factorization of binomial a*x^d+b              

faclib::sbinomial(d,a,b)
d - a positive integer number
a, b -  integer numbers

faclib::divisors -- get the divisors of n

faclib::divisors(n)
n - a positive integer number

faclib::qfunction -- compute the Q-function defined by E. J. Brabeau,
                     Polynomials, page 103, Springer Verlag New York, Inc., 1989

faclib::qfunction(n) 
n - a positive integer number

faclib::sbinomial may be called repeatly by faclib::binomial with the same
simple form of different input polynomials, so set "option remember"

faclib::divisors may be called by faclib::sbinomial and faclib::qfunction many
times with the same input number, so set "option remember"  

faclib::qfunction may be called by itself recursively, so set "option remember" 
--#

faclib::binomial:=proc(pa,pb)
local d, k, sf, xa, xb, xx, x, foo;
begin
    if lcoeff(pa)<0 then 
       return(faclib::binomial(multcoeffs(pa,-1),multcoeffs(pb,-1)));
    end_if;
    if nops(op(pa,2))=1 and type(expr(pb))=DOM_INT then 
       return(map(faclib::sbinomial(degree(pa),lcoeff(pa),lcoeff(pb)),\
                     subs,x=op(pa,[2,1])));
    end_if;
    # change the form of input polynomial to form a*x^d+b #
    if (d:=igcd(0,op(degreevec(pa)),op(degreevec(pb))))=1 then 
       return([pa+pb]); 
    else if nops((sf:=faclib::sbinomial(d,lcoeff(pa),lcoeff(pb))))=1 then 
            return([pa+pb]); 
         else 
              # restore the variables on the result of the simple form #
              foo:=proc(xx) begin
                 if type(xx)="_power" then op(xx,1)^(op(xx,2)/d)
                 elif type(xx)="_mult" then map(xx,foo)
                 else xx^(1/d)
                 end_if
              end_proc:
              xa:=foo(expr(lterm(pa)));
              xb:=foo(expr(lterm(pb)));
              map(sf, proc(xx) begin 
                                  poly(_plus(nthcoeff(xx,k)*\
                                  _power(xa,degree(nthterm(xx,k)))*\
                                  _power(xb,degree(xx)-degree(nthterm(xx,k)))\
                                  $hold(k)=1..nterms(xx)))
                         end_proc);
         end_if;
    end_if;
end_proc:




faclib::sbinomial:=proc(d,a,b)
local c, ds, f, fi, g, i, s, x, xx;
option remember;
begin
    # for the binomial of simple form x^d+(-)1 use faclib::qfunction directly #
    if a=abs(b) then 
       ds:=faclib::divisors(d);
       if b>0 then 
          ds:=[op({op(faclib::divisors(2*d))} minus {op(ds)})]; 
       end_if;
       return(map(ds,faclib::qfunction));
    else 
         # at first change a*x**d+b to form x^d+(-)1, then restore #
         # the coefficients on the result of its simple form       #
         fi:=ifactor(_power(a,d-1)*b);
         if (ds:=igcd(d,fi[2*i+1]$hold(i)=1..(nops(fi)-1)/2))=1 then
            return([poly(a*_power(x,d)+b)]);
         else c:=_mult(_power(fi[2*i],fi[2*i+1]/ds)$i=1..(nops(fi)-1)/2);
              case (g:=igcd(d, ds*2)) 
              of ds do 
              # simple case, the factors are irreducible #
                 f:=faclib::sbinomial(ds,1,sign(b));
                 f:=map(f, proc(xx) begin 
                                    faclib::primpart(multcoeffs(\
                                    poly(subs(expr(xx),x=x/c)),_power(c,g)))
                           end_proc);
                 break;
              of 4 do
                 # special case #
                 if b>0 then 
                    if c mod 2 =0 then 
                       if type((s:=sqrt(c/2)))=DOM_INT then 
                          f:=[poly(x*x-2*s*x+c),poly(x*x+2*s*x+c)];
                       else return([poly(a*_power(x,d)+b)]);
                       end_if;
                    else return([poly(a*_power(x,d)+b)]);
                    end_if;
                 else f:=[poly(x*x-c),poly(x*x+c)];
                 end_if; 
                 break;
              otherwise f:=faclib::sbinomial(ds,1,sign(b));
                        # these factors may be still reducible, # 
                        # factorize them further                #
                        f:=map(map(f,proc(xx) begin 
                                              faclib::primpart(multcoeffs(poly(\
                                              subs(expr(xx),x=x*x/c)),
                                              _power(c,g/2)))
                                     end_proc), 
                               faclib::pfactor, 1);
                        f:=[op(f,2*i-1)$hold(i)=1..nops(f)/2]; 
              end_case;
              map(f,proc(xx) begin 
                             faclib::primpart(poly(subs(expr(xx),\
                                                        x=_power(a*x,d/g))))
                    end_proc);
          end_if;        
    end_if;       
end_proc:

# use numlib::divisors with is very efficient, pz #
loadlib("numlib"):
#
numlib::divisors:= loadproc(numlib::divisors,
			    pathname("NUMLIB"), "divisors"):
#

faclib::divisors:=proc(n)
option remember;
begin
   numlib::divisors(n)
end_proc:

faclib::qfunction:=proc(n)
local ds, f, fi, i, j, ni, p, q, x;
option remember;
begin
    case n 
    of 1 do return(poly(x-1));
    of 9 do return(poly(x^6+x^3+1));
    of 15 do return(poly(x^8-x^7+x^5-x^4+x^3-x+1));
    otherwise if isprime(n) then 
                 return(poly(_plus(x^i$hold(i)=0..n-1)));
              elif n mod 2 =0 then 
                   f:=faclib::qfunction(n/2);
                   if n mod 4 =0 then 
                      return(poly(subs(expr(f),x=x*x)));
                   else return(poly(subs(expr(f),x=-x)));
                   end_if;
              else p:=[]; 
                   q:=[]; 
                   ds:=faclib::divisors(n);
                   for i in ds do 
                       if (ni:=n/i)=1 then 
                          p:=append(p,i);
                       else fi:=ifactor(ni); 
                            fi:=[op(fi,2*j+1)$hold(j)=1..(nops(fi)-1)/2];
                            if _and(fi[j]=1$hold(j)=1..nops(fi)) then
                               case _power(-1,nops(fi))
                               of 1 do p:=append(p,i); break;
                               of -1 do q:=append(q,i);
                               end_case;
                            end_if;
                       end_if;
                    end_for;
                    divide(poly(_mult((x^p[j]-1)$hold(j)=1..nops(p))), \
                           poly(_mult((x^q[j]-1)$hold(j)=1..nops(q))), Exact);
               end_if;
    end_case;
end_proc:
             
