# $Date: 1994/11/23 14:15:54 $ $ Author: yuan $ #

#--
faclib::canzas -- split the product of all monic irreducible factors of degree 
                  i via Cantor-Zassenhaus method (see Keith O. Geddes, Stephen
                  R. Czapor and George Labahn, Algorithms for computer algebra,
                  page 373, Kluwer Academic Publishers, 1992), output is a set
                  of factors in polynomial form.

faclib::canzas(fpoly,i,matrix,p,x) 
fpoly - a univatiate polynomial, it is the product of all monic irreducible
        factors of degree i
i - a positive integer number 
matrix - a list of polynomials, matrix[i]=divide(x^(i*p),fpoly0, Rem) and
         fpoly0=fpoly*(another polynomial)      
p - the prime number>2, all the related polynomials are in Zp
x - the indeterminate

faclib::canzas use faclib::Rc as a global variable
--#

faclib::canzas:=proc(fpoly,i,matrix,p,x)
local d, dim, f, j, m, rp, pp;
begin
    if degree(fpoly)=i then 
       return({fpoly})
    end_if; 
    dim:=degree(fpoly)-1;
    if type(matrix)=DOM_TABLE then # ddf_shoup was used #
       matrix:=[divide(matrix[m],fpoly,Rem)$hold(m)=1..nops(matrix)-1];
       if nops(matrix)<dim then # compute remaining powers #
          for j from nops(matrix)+1 to dim do
             matrix:=append(matrix,divide(matrix[j-1]*matrix[1],fpoly,Rem))
          end_for
       end_if
    elif dim<nops(matrix) then 
       # compute matrix[i]=divide(x^(i*p),fpoly,Rem) #
       matrix:=[divide(matrix[m],fpoly,Rem)$hold(m)=1..dim];   
    end_if;
    repeat d:=powermod(faclib::Rc(),dim,dim-1)+1; 
           # generates a random polynomial over Zp # 
           # of degree lower than that of fpoly    #
           rp:=poly(faclib::Rc()+_plus(faclib::Rc()*_power(x,m)$hold(m)=1..d)\
                    +_power(x,d+1),[x],IntMod(p));
           pp:=rp;
           # use matrix to compute rp^(p^(i-1)) mod fpoly #
           for m from 1 to i-1 do
               rp:=poly(coeff(rp,0),[x],IntMod(p))+_plus(\
                              multcoeffs(matrix[j],coeff(rp,j))$hold(j)=1..dim);
               pp:=rp+pp;
           end_for;
           pp:=faclib::powermod_poly(pp,(p-1)/2,fpoly)-poly(1,[x],IntMod(p));
           pp:=faclib::univ_mod_gcd(fpoly,pp);
           if degree(pp)>0 and pp<>fpoly then
              f:=faclib::canzas(pp,i,matrix,p,x) union
                 faclib::canzas(divide(fpoly,pp,Quo),i,matrix,p,x);
           end_if;
    until nops(f)=degree(fpoly)/i end_repeat;
    f;
end_proc:

faclib::canzas_lin:=proc(fpoly,p,x) # split into linear factors (case i=1) #
local pp,f;
begin
# return list instead of sets because it is more efficient #
   if degree(fpoly)=1 then 
      if lcoeff(fpoly)<>1 then fpoly:=multcoeffs(fpoly,1/lcoeff(fpoly)) end_if;
      return([fpoly]) 
   end_if;
   repeat
      pp:=poly(x+faclib::Rc(),[x],IntMod(p));
      pp:=faclib::powermod_poly(pp,(p-1)/2,fpoly)-poly(1,[x],IntMod(p));
      pp:=faclib::univ_mod_gcd(pp,fpoly);
      if degree(pp)>0 and degree(pp)<degree(fpoly) then
         f:=faclib::canzas_lin(pp,p,x) . faclib::canzas_lin(divide(fpoly,pp,Quo),p,x)
      end_if
   until nops(f)=degree(fpoly) end_repeat;
   f
end_proc:

