# $Date: 1994/11/03 23:30:44 $ $ Author: yuan $ #

#--
faclib::canzas_2 -- split the product of all monic irreducible factors of degree
                    i in Zp when p=2, via Cantor-Zassenhaus method (see Keith O.
                    Geddes, Stephen R. Czapor and George Labahn, Algorithms for
                    computer algebra, page 373, Kluwer Academic Publishers,
                    1992), output is a set of factors in polynomial form.

faclib::canzas_2(fpoly,i,x) 
fpoly - a univatiate polynomial, it is the product of all monic irreducible
        factors of degree i in Zp (p=2)
i - a positive integer number 
x - the indeterminate
--#

faclib::canzas_2:=proc(fpoly,i,x)
local d, f, m, pp;
begin
    if (d:=degree(fpoly))=i then 
       return({fpoly});
    end_if; 
    if type(SEED)=DOM_IDENT then SEED:=1 end_if;
    repeat 
	   # pp:=poly(_plus(Rc()*_power(x,m)$hold(m)=0..d-1),[x],IntMod(2)); #
	   # replaced by a direct random generation (pz) #
	   pp:=poly(_plus(((SEED:=427419669081*SEED mod 999999999989) mod 2)*x^m$m=0..d-1),
		[x],IntMod(2));
	   pp:=faclib::univ_mod_gcd(fpoly,pp);
           if degree(pp)>0 and pp<>fpoly then
              f:=faclib::canzas_2(pp,i,x) union
                 faclib::canzas_2(divide(fpoly,pp,Quo),i,x);
           end_if;
    until nops(f)=d/i end_repeat;
    f;
end_proc:



