# $Date: 1994/10/27 21:07:39 $ $ Author: yuan $ #

#--
faclib::pdeg2 -- return the factorization of bivariate polynomial of degree 2 by
                 solving the quadratic equation in Z[x], output is a list of
                 factors in polynomial form. 
                
faclib::pdeg2(p,x) 
p - a polynomial of degree 2 in Z[x] and it may be a bivariate polynomial 
x - the main variable, p in Z[x] has degree 2
--#

faclib::pdeg2:=proc(p,x)
local c, c1, c2, i, p0, px, py, s, sc, sq, x0, y, X;
begin
    X:= op(p,2);
    px:=poly(p,[x]);
    c:=0;
    if type((sq:=expand(_power(coeff(px,1),2)-4*coeff(px,2)*coeff(px,0))))\
           =DOM_INT then 
       if type((x0:=sqrt(sq)))=DOM_INT then 
          c:=1; 
          # for univariate case, it is straightforward #
          if nops(X)=1 then 
             p0:=2*coeff(p,2)*x+coeff(p,1);
             return([faclib::primpart(poly(p0+x0,X)),
		     faclib::primpart(poly(p0-x0,X))]);
	  else
             y:=X[2];
          end_if;
       end_if;
    else y:=X[2];
         # use faclib::quafree to see if sq is the square of a polynomial #
         py:=poly(sq,[y]); 
         if _and(lcoeff(py)>0, tcoeff(py)>0) then 
            if type((sc:=sqrt(icontent(py))))=DOM_INT then
               if type((s:=degree(nthterm(py,nterms(py)))/2))=DOM_INT then
                  x0:=sc*y^s;
                  if expr((py:=divide(py,poly(x0^2,[y]),Exact)))=1 then 
                     c:=1;
                  elif _and(type(sqrt(lcoeff(py)))=DOM_INT, \
                            type(sqrt(tcoeff(py)))=DOM_INT, \
                            degree(lterm(py)) mod 2=0) then 
                       s:=faclib::quafree(py);
                       if _and((op(s,2*i) mod 2=0)$hold(i)=1..nops(s)/2) then
                          x0:=expand(x0*_mult(_power(expr(op(s,2*i-1)),\
                                     op(s,2*i)/2)$hold(i)=1..nops(s)/2)); 
                          c:=1;
                       end_if;
                  end_if;
               end_if;
            end_if;
         end_if;
    end_if; 
    # change the factors into primitive form # 
    if c=1 then 
       c:=2*lcoeff(px); 
       c1:=coeff(px,1)-x0;
       c2:=coeff(px,1)+x0;
       return([divide(poly(c*x+c1,X),poly(gcd(c,c1),X),Exact),\
               divide(poly(c*x+c2,X),poly(gcd(c,c2),X),Exact)]);
    else return([p]);
    end_if;
end_proc:

