# $Date: 1994/09/27 09:59:19 $ $ Author: yuan $ #

#--
faclib::psqrfree -- return the square free factorization of polynomial in Z,
                    output is given in form [f1,e1,..,fn,en] and fi is in
                    polynomial form, p=f1^e1*..*fn^en.

faclib::psqrfree(p,c)
p - a primitive polynomial in Z has no monomial factor 
c - an integer number, may equal to 0, 1, or 2

faclib::psqrfree get the factors with different variables and the factors with
different powers
--#

faclib::psqrfree:=proc(p,c)
local f, pf, x;
begin

    # for polynomial of degree 1 return the input; for binomial, #
    # it is square free, so also return the input directly       #
    if degree(p)=1 or nterms(p)=2 then 
       return([p,1]);
    end_if;
    # sort variables of multivariate polynomial according to ascending degrees #
    if nops(op(p,2))>1 then 
       p:=faclib::indsort(p); 
    elif c=0 then 
         c:=1; 
    end_if;
    # c=0: polynomial may be factorized into factors with different variables #
    if c=0 then 
       f:=[];
       if degree(p,op(p,[2,1]))=1 then 
          if (pf:=faclib::pfs(p,op(p,[2,1])))<>1 then
             f:=f.faclib::psqrfree(poly(expr(pf)),0); 
             p:=poly(expr(divide(p,pf,Exact)));
          end_if;
          return(append(f,p,1)); 
       end_if;
       for x in op(p,2) do 
           if degree(poly(p,[x]))>0 then 
              if (pf:=faclib::pfs(p,x))<>1 then
                 f:=f.faclib::psqrfree(poly(expr(pf)),0);
                 p:=poly(expr(divide(p,pf,Exact)));
              end_if;
           end_if;
       end_for;
       return(f.faclib::psqrfree(p,1));
    elif degree(p,op(p,[2,1]))=1 then 
         # for c>0 and sorted polynomial, if degree of its # 
         # first variable is 1, then it is irreducible     # 
         return([p,1]);         
    end_if;
    # c=1: polynomial may be factorized into factors with different powers #
    faclib::quafree(p);         
end_proc:            


  
