faclib::ddf_shoup := proc(f,p,x) 
# f is the polynomial, p the prime number, x the undeterminate #
local n,h,B,l,i,H,j,m,t,II,F,fstar,g,res,d;
begin
   n:=degree(f);
   B:=n div 2;
   l:=ceil(float(sqrt(B)));
   m:=B div l; if m*l<B then m:=m+1 end_if; # m = ceil(B/l) #
   # step 1 #
   h[0]:=poly(x,[x],IntMod(p));
   h[1]:=faclib::powermod_poly(h[0],p,f);
   t:=2*ceil(float(sqrt(n))); # page 9 : we used t = 2*ceil(n^(1/2)) #
   # step 2 #
   for i from 2 to l do h[i]:=faclib::mcp(h[i-1],h[1],f,n,t) end_for;
   # step 3 #
   H[1]:=h[l];
   for j from 2 to m do H[j]:=faclib::mcp(H[j-1],H[1],f,n,t) end_for;
   # step 4 #
   for j from 1 to m do
      II[j]:=H[j]-h[0];
      for i from 1 to l-1 do 
         II[j]:=divide(II[j]*(H[j]-h[i]),f,Rem) 
      end_for
   end_for;
   # step 5 #
   for i from 1 to n do F[i]:=poly(1,[x],IntMod(p)) end_for;
   fstar:=f;
   for j from 1 to m do
      g:=faclib::univ_mod_gcd(fstar,II[j]);
      fstar:=divide(fstar,g,Exact);
      for i from l-1 downto 0 do
         F[l*j-i]:=faclib::univ_mod_gcd(g,H[j]-h[i]);
         g:=divide(g,F[l*j-i],Exact)
      end_for
   end_for;
   if degree(fstar)<>0 then F[degree(fstar)]:=fstar end_if;
   res:=[];
   for i from 1 to n do
      d:=degree(F[i]);
      if d>0 then res:=append(res,[F[i],i]) end_if
   end_for;
   [res,faclib::power_table(h[1],f,t)]
end_proc:

faclib::power_table := proc(h,f,t)
# constructs the table h^i for 0 <= i <= t #
# option remember because it will be used several times #
local powh,i;
option remember;
begin
   powh[0]:=subsop(h,1=1); # 1 #
   powh[1]:=h;
   for i from 2 to t do powh[i]:=divide(powh[i-1]*h,f,Rem) end_for;
   powh
end_proc:

faclib::mcp := proc(g,h,f,n,t) # compute g(h) mod f #
local powh,G,j,gofh,res,i;
begin
   # compute the table of h^i for 0 <= i <= t #
   powh:=faclib::power_table(h,f,t);
   # decompose g into sum(gj(x)*(x^t)^j,j=0..n div t) where deg(gj)<t #
   for j from 0 to n div t do
      gofh[j]:=_plus(multcoeffs(powh[i],coeff(g,t*j+i)) $ i=0..t-1) # gj(h) mod f #
   end_for;
   # now apply Horner scheme to compute sum(gj(h)*(h^t)^j,j=0..n div t) #
   res:=gofh[n div t];
   for j from (n div t)-1 downto 0 do
      res:=divide(res*powh[t]+gofh[j],f,Rem)
   end_for;
end_proc:

