# $Date: 1995/02/22 15:23:59 $ $Author: kg $ $Revision: 1.2 $ #

# kg, 09/12/93 #

#--
gcdlib::coeff_type -- returns the smallest coefficient domain of polynomials

gcdlib::coeff_type([p1,..,pn])

[p1,...,pn] - list of polynomials with coefficient ring 'Expr'

gcdlib::coeff_type returns one of DOM_INT, DOM_RAT, DOM_FLOAT,
DOM_COMPLEX or DOM_EXPR such that every coefficient of the polynomials
[p1,...,pn] may be interpreted as beeing member in this domain.

Examples:
gcdlib::coeff_type(poly(2*x+2/3))    --> DOM_RAT
gcdlib::coeff_type(poly(2*x+a, [x])) --> DOM_EXPR
--#

gcdlib::coeff_type:= proc(a)
    local t, p;
begin
    t:= map( { op(map(a, coeff)) }, domtype);

    t:= t minus {DOM_INT};
    if t = {} then return(DOM_INT) end_if;
    t:= t minus {DOM_RAT};
    if t = {} then return(DOM_RAT) end_if;
    t:= t minus {DOM_FLOAT};
    if t = {} then return(DOM_FLOAT) end_if;
    t:= t minus {DOM_COMPLEX};
    if t = {} then return(DOM_COMPLEX) end_if;
    DOM_EXPR
end_proc:

# end of file #
