# $Date: 1994/09/14 15:26:25 $ $Author: kg $ $Revision: 1.5 $ #

# kg, 30/07/94 #

#--
gcdlib::dom_gcd -- compute gcd of 2 polynomials over a domain

gcdlib::dom_gcd(p1, p2)

p1,p2 - non-zero polynomials over a domain
--#

gcdlib::dom_gcd:= proc(a, b)
    local x, X, T, g, r, i, j;
begin
    X:= op(a,2);
    T:= op(a,3);

    # univariate case? #
    if nops(X) = 1 then
	r:= gcdlib::udom_gcd(a,b)
    else
	# reduce to univariate case #
	x:= X[1];
	X[1]:= NIL;
	a:= poly(a, [x], Poly(X,T));
	b:= poly(b, [x], Poly(X,T));
	g:= gcdlib::udom_gcd(a,b);

	# convert back to multivariate polynomial #
	X:= [x].X;
	r:= poly(T::zero,X,T);
	for i from 1 to nterms(g) do
	    x:= nthcoeff(g,i);
	    r:= r + poly(nthterm(g,i),X,T) *
		    _plus((poly(nthcoeff(x,j),X,T) * poly(nthterm(x,j),X,T))
			  $ j=1..nterms(x));
	end_for;
    end_if;

    # normalize result if possible #
    if T::unitNormalRep <> FAIL then
	x:= T::unitNormalRep(lcoeff(r));
	r:= multcoeffs(r, x[2]);
    end_if;
    r
end_proc:

# end of file #
