# $Date: 1994/09/13 09:04:25 $ $Author: kg $ $Revision: 1.2 $ #

# kg, 09/12/93 #

#--
gcdlib::mod_sparse_gcd -- compute the gcd of IntMod-polynomials using
	sparse Zippel interpolation

gcdlib::mod_sparse_gcd(p1, p2)

p1,p2 - non-zero polynomials over IntMod

gcdlib::mod_sparse_gcd computes the gcd of 2 non-zero polynomials
over IntMod(p). p must be prime. The arguments are not checked further.
Sparse Zippel interpolation is used to calculate the gcd.
gcdlib::mod_sparse_gcd returns FAIL if the starting point is bad.

See R.Zippel "Probabilistic Algorithms for Sparse Polynomials",
in: Symbolic & Algebraic Comp. (Ed E.W.Ng), Springer 1979, pp216
--#

gcdlib::mod_sparse_gcd:= proc(a, b)
    local p, T, Tg, Th, y, x, X, nv, av, bv, av0, bv0, cc, ch,
	  gl, glv, glv0, d, gv, gc, gcn, h, ph, q, lim, v0, v, V,
	  tn, t, sv, svn, i, j, k, S, Sn, rand;
begin
    X:= op(a,2);
    nv:= nops(X)-1;
    T:= X, op(a,3);
    p:= op(T,[2,1]);
    y:= X[nv+1];
    X[nv+1]:= NIL;
    rand:= gcdlib::gen_random[p];

    # nomalize args #
    a:= multcoeffs(a, 1/lcoeff(a));
    b:= multcoeffs(b, 1/lcoeff(b));

    # compute contents of a and b, viewed as polynomials in y over
      Zp[x1,...,xn] #
    Th:= [y], Poly(X, IntMod(p));
    av:= poly(a, Th);
    bv:= poly(b, Th);
    gl:= poly(1, X, IntMod(p));

    if lcoeff(av) = gl or lcoeff(bv) = gl then
	cc:= poly(1, T);
    else
	av0:= gcdlib::poly_mod_content(av);
	bv0:= gcdlib::poly_mod_content(bv);
	cc:= poly(gcdlib::mod_gcd(av0,bv0), T);

	# remove contents from a and b #
	av:= mapcoeffs(av, divide, av0, Exact);
	bv:= mapcoeffs(bv, divide, bv0, Exact);
	gl:= gcdlib::mod_gcd(lcoeff(av), lcoeff(bv));

	# view a and b again as polynomials in X over Zp #
	a:= poly(av, T);
	b:= poly(bv, T);
    end_if;

    # pick random nv-Tupel v0 #
    repeat
	v0:= [ (X[i]=rand()) $ i=1..nv ];
	glv:= evalp(gl, op(v0));
    until glv <> 0 end_repeat;

    # init dense interpolation for x1 #
    x:= X[1];
    if nv = 1 then
	Th:= T;
	av0:= a;
	bv0:= b;
	glv0:= gl;
    else
	Th:= [x,y], IntMod(p);
	V:= op(v0,2..nv);
	av0:= evalp(a, V);
	bv0:= evalp(b, V);
	glv0:= evalp(gl, V);
    end_if;

    v:= op(v0[1],2);
    V:= { v };
    h:= gcdlib::univ_mod_gcd(evalp(av0, v0[1]), evalp(bv0, v0[1]));
    if not iszero(h) then
	h:= poly(multcoeffs(h, glv / lcoeff(h)), Th)
    end_if;
    q:= poly(x - v, Th);

    lim:= min(degree(a,x), degree(b,x));

    # dense interpolation loop for x1 #
    while lim > 0 do

	# pick random value for x1 #
	repeat
	    v:= x=rand();
	    glv:= evalp(glv0, v);
	until not contains(V, op(v,2)) and glv <> 0 end_repeat;

	gv:= gcdlib::univ_mod_gcd(evalp(av0, v), evalp(bv0, v));
	if not iszero(gv) then
	    gv:= multcoeffs(gv, glv / lcoeff(gv))
	end_if;

	# dense polynomial Newton interpolation #
	lim:= lim-1;

	# compute Newton coefficient #
	gv:= gv - evalp(h, v);
	v:= op(v,2);
	_mult(op(map(V, -_plus, -v)));
	gv:= multcoeffs(gv, 1/%);

	# update polynomial #
	if not iszero(gv) then
	    h:= h + poly(gv, Th) * q;
	end_if;

	if lim = 0 then break end_if;

	if iszero(gv) then

	    # get primitive part of h #
	    ph:= poly(h, [y], Poly([x], IntMod(p)));
	    ph:= mapcoeffs(ph, divide, gcdlib::poly_mod_content(ph), Exact);
	    ph:= poly(ph, Th);

	    # test division #
	    if divide(av0, ph, Exact) <> FAIL then
		if divide(bv0, ph, Exact) <> FAIL then
		    if nv = 1 then return(cc * ph) end_if;
		    break
		end_if
	    end_if;
	end_if;

	q:= poly(x-v, Th) * q;
	V:= V union { v };
    end_while;

    # loop over x2,...,xn #
    for k from 1 to nv-1 do

	# built skeleton from h #
	d:= degree(h,y);
	S:= [ [] $ i=0..d ];
	for j from 1 to nterms(h) do
	    t:= nthterm(h,j);
	    d:= degree(t,y)+1;
	    S[d]:= append(S[d], t)
	end_for;
	t:= max(nops(S[i]) $ i=1..nops(S));

	# init dense interpolation for x(k+1) #
	Tg:= Th;
	x:= X[k+1];
	if nv = k+1 then
	    Th:= T;
	    av0:= a;
	    bv0:= b;
	    glv0:= gl;
	else
	    Th:= [op(X,1..k+1),y], IntMod(p);
	    V:= op(v0,k+2..nv);
	    av0:= evalp(a, V);
	    bv0:= evalp(b, V);
	    glv0:= evalp(gl, V);
	end_if;

	v:= op(v0[k+1],2);
	V:= { v };
	h:= poly(h, Th);
	q:= poly(x - v, Th);

	lim:= min(degree(a,x), degree(b,x));

	# dense interpolation loop for x(k+1) #
	while lim > 0 do

	    # pick random evaluation point for dense interpolation #
	    repeat
		v:= x=rand();
		glv:= evalp(glv0, v);
	    until not contains(V, op(v,2)) and evalp(glv, op(v0,1..k)) <> 0
	    end_repeat;

	    av:= evalp(av0, v);
	    bv:= evalp(bv0, v);

	    # repeat sparse interpolation step until sparse evaluation
	      points allow a solution #
	    repeat

		# pick random sparse evaluation point (k-tupel) #
		repeat
		    sv:= [ rand() $ i=1..k ];
		until evalp(glv, (X[i]=sv[i]) $ i=1..k) <> 0 end_repeat;

		# get corresponding gcd's at sv^i for i=0..t-1 #
		gc:= [];
		for j from 0 to t-1 do
		    svn:= (X[i]=powermod(sv[i],j,p)) $ i=1..k;
		    gcn:= gcdlib::univ_mod_gcd(evalp(av, svn), evalp(bv, svn));
		    if not iszero(gcn) then
			gcn:= multcoeffs(gcn, evalp(glv, svn)/lcoeff(gcn))
		    end_if;
		    gc:= append(gc, gcn)
		end_for;

		# solve lin. equ. for each coeff of h (viewed as polynomial
		  in x1) #
		gv:= poly(0, Tg);
		svn:= ((X[i]=sv[i]) $ i=1..k), y=1;
		for j from 1 to nops(S) do

		    # assemble and solve transpose Vandermonde system #
		    Sn:= S[j];
		    tn:= nops(Sn);
		    if tn = 1 then
			gv:= gv + multcoeffs(Sn[1], coeff(gc[1], j-1));
		    elif tn > 1 then
			ch:= gcdlib::vanderm_mod_solve(
				    [ evalp(Sn[i], svn) $ i=1..tn ],
				    [ coeff(gc[i], j-1) $ i=1..tn ], p);
			if ch = FAIL then break end_if;

			# the solution are the coeffs of the j-th coeff of gv #
			gv:= gv + _plus(multcoeffs(Sn[i], ch[i]) $ i=1..tn);
		    end_if
		end_for;
	    until ch <> FAIL end_repeat;

	    # dense polynomial Newton interpolation #
	    lim:= lim-1;

	    # compute Newton coefficient #
	    gv:= gv - evalp(h, v);
	    v:= op(v,2);
	    _mult(op(map(V, -_plus, -v)));
	    gv:= multcoeffs(gv, 1/%);

	    # update polynomial #
	    if not iszero(gv) then
		h:= h + poly(gv, Th) * q;
	    end_if;

	    if lim = 0 then break end_if;

	    if iszero(gv) then

		# get primitive part of h #
		ph:= poly(h, [y], Poly([op(X,1..k+1)], IntMod(p)));
		ph:= mapcoeffs(ph, divide, gcdlib::poly_mod_content(ph), Exact);
		ph:= poly(ph, Th);

		# test division #
		if divide(av0, ph, Exact) <> FAIL then
		    if divide(bv0, ph, Exact) <> FAIL then
			if nv = k+1 then return(cc * ph) end_if;
			break
		    end_if
		end_if;
	    end_if;

	    q:= poly(x-v, Th) * q;
	    V:= V union { v };
	end_while;
    end_for;

    # get primitive part of h #
    ph:= poly(h, [y], Poly([op(X,1..nv)], IntMod(p)));
    ph:= mapcoeffs(ph, divide, gcdlib::poly_mod_content(ph), Exact);
    ph:= poly(ph, Th);

    # test division #
    if divide(a, ph, Exact) <> FAIL then
	if divide(b, ph, Exact) <> FAIL then
	    return(cc * ph)
	end_if
    end_if;
    FAIL
end_proc:

# end of file #
