# $Date: 1994/08/01 08:18:38 $ $Author: kg $ $Revision: 1.1 $ #

# kg, 30/07/94 #

#--
gcdlib::udom_gcd -- compute gcd of 2 univariate polynomials over a domain

gcdlib::udom_gcd(p1, p2)

p1,p2 - non-zero univariate polynomials over a domain

--#

gcdlib::udom_gcd:= proc(a, b)
    local c, gc, n, m, d, s, h, l, t, D;
begin
    D:= op(a,3);

    # make polynomials primitive #
    c:= content(a);
    a:= mapcoeffs(a, D::divex, c);
    gc:= content(b);
    b:= mapcoeffs(b, D::divex, gc);
    gc:= D::gcd(c, gc);

    # subresultant gcd #
    n:= degree(a);
    m:= degree(b);
    if n < m then
	t:= a; a:= b; b:= t;
	t:= n; n:= m; m:= t;
    end_if;
    s:= D::one;
    h:= s;
    l:= s;

    while not iszero(b) do
	d:= n - m;
	s:= D::_mult(l, D::_power(h, d));
	if ((d mod 2) = 0) then s:= D::negate(s) end_if;
	t:= mapcoeffs(pdivide(a, b, Rem), D::divex, s);
	a:= b;
	b:= t;
	n:= m;
	m:= degree(b);
	l:= lcoeff(a);
	case d
	of 0 do break;
	of 1 do h:= l; break;
	otherwise h:= D::divex(D::_power(l, d), D::_power(h, d-1));
	end_case;
    end_while;

    # make result primitive #
    multcoeffs(mapcoeffs(a, D::divex, content(a)), gc);
end_proc:

# end of file #
