# $Date: 1995/03/21 16:05:04 $ $Author: kg $ $Revision: 1.6 $ #

# kg, 27/12/93 #

#++
gbasis  - returns reduced normalized Gr"obner-basis for polynomials in list S

gbasis(S [,o] [,r])

S - list of polynomials
o - otional term ordering (LexOrder, DegInvLexOrder or DegreeOrder)
r - optional identifier 'Reorder'

If no term ordering is given, 'DegInvLexOrder' is used.

If the option 'Reorder' is given, the order of the indets may be changed
during the computation of the basis. (The order of the indets is changed
to be "heuristically optimal" in the sense of Boege, Gebauer and Kredel.)
In this case the result is returned with the re-arranged variables.
++#

groebner::gbasis:= proc(S, o)
    local i, reord, X, order, zero, monic, conv;
begin
    case args(0)
    of 1 do
	o:= hold(DegInvLexOrder);
	reord:= FALSE;
	break;
    of 2 do
	if args(2) = hold(Reorder) then
	    o:= hold(DegInvLexOrder);
	    reord:= TRUE;
	else
	    reord:= FALSE;
	end_if;
	break;
    of 3 do
	reord:= TRUE;
	if args(2) = hold(Reorder) then
	    o:= args(3)
	end_if;
    end_case;

    if testargs() then
	if args(0) < 1 or args(0) > 3 then error("wrong no of args") end_if;
	if args(0) = 3 then
	    if args(2) <> hold(Reorder) and args(3) <> hold(Reorder) then
		error("invalid argument")
	    end_if;
	end_if;
	if domtype(S) <> DOM_LIST then
	    error("no polynomial list")
	end_if;
	if nops(S) = 0 then
	    error("no polynomials in list")
	end_if;
	if domtype(S[1]) = DOM_POLY then
	    groebner::test_polyset(S)
	end_if;
	if not contains({hold(DegreeOrder), hold(LexOrder), hold(DegInvLexOrder)}, o) then
	    error("unknown order")
	end_if;
    end_if;

    if domtype(S[1]) <> DOM_POLY then
	S:= gcdlib::expr2polys(S, Type::Rational);
	if S = FAIL then error("not a rational polynomial") end_if;
	conv:= expr;
	reord:= TRUE;	# the user didn't care #
    else
	conv:= id
    end_if;

    zero:= S[1];
    S:= select(S, not iszero);
    if nops(S) = 0 then 
        return([zero]) 
    end_if;

    if reord then
	# re-arrange variables #
	X:= groebner::opt_order(S);
	if X <> op(S[1],2) then
	    S:= map(S, poly, X)
	end_if
    end_if;

    # set actual order and zero #
    order:= groebner::order;
    groebner::order:= o;
    zero:= groebner::zero;
    groebner::zero:= S[1]^0;
    groebner::zero:= groebner::zero - groebner::zero;

    # install normalizing routine #
    monic:= groebner::monic;
    if op(S[1],3) = hold(Expr) then
	groebner::monic:= groebner::primpart
    else
	groebner::monic:= groebner::normalize
    end_if;

    # normalize polynomials #
    S:= map(S, groebner::monic);

    # compute and reduce basis #
    S:= groebner::reduce_basis(groebner::basis(S));
    if nops(S) = 0 then
    	S:= [ groebner::zero ]
    elif op(S[1],3) = hold(Expr) then
        # change into unit normal form #
        S:= map(S, fun((
        	if sign(lcoeff(args(1), o)) < 0 then
		    multcoeffs(args(1), -1)
		else
		    args(1)
		end_if)))
    end_if;

    # re-install original globals #
    groebner::order:= order;
    groebner::zero:= zero;
    groebner::monic:= monic;

    map(S, conv)
end_proc:

# end of file #
