# $Date: 1995/03/21 12:09:59 $ $Author: kg $ $Revision: 1.4 $ #

# kg, 03/01/94 #

#--
opt_order -- find heuristically optimal variable ordering

opt_order(S)

S - list of polynomials

opt_order returns a re-arranged list of variables of the polynomials in S
where the ordering of the variables is "heuristically optimal" in the
sense of Boege et al. (See W. Boege, R.Gebauer, H.Kredel:"Some Examples
for Solving Equations by Calculating Groebner Bases", J. Symbolic Comp.
(1986) Vol 1, 83-98.)
--#

groebner::opt_order:= proc(S)
    local n, i, j, k, X, P, O, T;
begin
    X:= op(S[1], 2);
    T:= op(S[1], 3);
    n:= nops(X);

    if T = hold(Expr) then
        S:= map(S, mapcoeffs, 1);
    elif domtype(T) = DOM_DOMAIN then
        S:= map(map(S, mapcoeffs, T::one), poly, hold(Expr));
    else
    	S:= map(map(S, mapcoeffs, 1), poly, hold(Expr));
    end_if;
    O:= nops(S);
    P:= [ subs(_plus(evalp(S[k], X[j]=1 $ j=1..i-1, X[j]=1 $ j=i+1..n)
	    $ k=1..O), X[i]=X[1]) $ i=1..n ];

    O:= sort([i $ i=1..n], fun(lcoeff(P[args(2)]-P[args(1)]) > 0));

    [ X[O[i]] $ i=1..n ]
end_proc:

# end of file #
