# $Date: 1994/10/03 22:53:37 $ $Author: kraume $ $Revision: 1.2 $ #
#--
intlib::gcdex(a,b) - extended Euclidean algorithm. Computes gcd(a,b),s and t 
such that a*s + b*t = gcd(a,b).
K.O. Geddes, Algorithms for Computer Algebra, Algorithm 2.2
--# 
intlib::gcdex:= proc(a,b)
  local c1,c2,d1,d2,r,r1,r2,v,l,la,lb;
begin
  v:=op(a,2); la:=1/lcoeff(a); lb:=1/lcoeff(b);
  a:=intlib::sim(multcoeffs(a,la)); b:=intlib::sim(multcoeffs(b,lb));
  c1:=poly(1,v); d2:=c1; d1:=poly(0,v); c2:=d1;
  while not iszero(b) do
    r:=intlib::sim(divide(a,b));
    r1:= c1-r[1]*d1; r2:= c2-r[1]*d2;
    a:= b; c1:= d1; c2:= d2;
    b:= r[2]; d1:= r1; d2:= r2;
  end_while;
  l:= 1/lcoeff(a);
  intlib::sim(multcoeffs(a,l),multcoeffs(c1,l*la),multcoeffs(c2,l*lb));
end_proc:
