# $Date: 1994/10/03 22:53:39 $ $Author: kraume $ $Revision: 1.2 $ #
#--
The input for the procedure intlib::hermite is the function f in the field 
extension k[n] splitted into numerator and denominator of the special part and 
the normal part of f respectively, where the denominator is a table of 
square-free polynomials. It computes g and h, which is simple, so that g'+h=f.
M. Bronstein, A Unification of Liouvillian Extension, AAECC 1990, 1
--#
intlib::hermite:=proc(f_sNum,f_sDen,H,V,n)
  local i,m,x,C,S,T,U,G,W,g;
# global k_sub; #
begin
  if iszero(H) or nops(V)=1 then return(f_sNum,f_sDen,H,V[1],0); end_if;
  U[1]:=V[1];
  for i from 2 to nops(V)-1 do
    U[i]:=U[i-1]*V[i]^i;
  end_for;
  x:=k_sub[n]; g:=poly(0,[x]),poly(1,[x]);
  for m from nops(V) downto 2 do
    if (G:=V[m])=poly(1,[x]) then m:=m-1; next; end_if;
    W:=G^(m-1);
    H:=intlib::sim(divide(H,G));
    C:=intlib::sim(divide(multcoeffs(U[m-1],1-m)*intlib::diffs(G,n),G));
    intlib::pdioe(C[2],G,H[2]); S:=%1[1]; T:=%2[2];
    H:=intlib::sim(T+H[1]-C[1]*S-U[m-1]*intlib::diffs(S,n));
    H:=intlib::sim(divide(H,U[m-1]*W)); f_sNum:=f_sNum+H[1]*f_sDen;
    T:=intlib::gcdk_n(g[2],G^(m-1));
    g:=g[1]*divide(W,T,Quo)+S*divide(g[2],T,Quo),divide(g[2]*W,T,Quo);
    if iszero((H:=H[2])) then break; end_if;
    W[m-1]:=G; i:=m-1;
# update of the square-free factorisation #
    while (G:=intlib::gcdk_n(H,G))<>poly(1,[x]) and i>0 do
      H:=intlib::sim(divide(H,G,Quo));
      W[i]:=intlib::sim(divide(W[i],G,Quo));
      i:=i-1;
      W[i]:=G;
    end_while;
    for i from max(i,1) to m-1 do
      V[i]:=intlib::sim(V[i]*W[i]);
      U[i]:=intlib::sim(U[i]*W[i]^i);
    end_for;
  end_for;
  return(f_sNum,f_sDen,H,U[1],expr(g[1])/expr(g[2]));
end_proc:
