# $Date: 1995/06/30 14:45:22 $ $Author: zimmerma $ $Revision: 1.16 $ #
#--
intlib::int(f,x) - computes the integral of the function f(x) with respect to 
the variable x.
--#
intlib::int:=proc(f,x)
local opt,n,k_sub,k_ident,k_diff,k_deg,k_alg,Q,Q_sub,i,j,integral,tosubs,hassincos,k,hasI;
begin
# test of input and options #
  if testargs()
    then 
	 # already checked in int #
         # if args(0)<>2 then error("wrong no of arguments") end_if; #
         if domtype(f)<>DOM_IDENT and domtype(f)<>DOM_EXPR
            and not(testtype(f,NUMERIC))
           then error("Illegal integrand"); end_if;
         # if not(testtype(x,DOM_IDENT)) then error("Illegal argument"); end_if; #
  end_if;
  hassincos:=has(f,{sin,cos}); hasI:=has(f,I);
  # lookup method #
  integral:=intlib::lookup(subs(f,x=_X));
  if integral<>FAIL then return(subs(integral,_X=x)) end_if;
  opt:=hold(Exp);
  n:=1; k:=[x];
  k_sub:=[x]; k_ident:=[genident()]; k_diff:=[1]; k_deg:=[0]; k_alg:=[0];
  Q:=[]; Q_sub:=[];
# substitution and construction of the field extensions of the rational numbers#
  f:=intlib::subst(f);
  userinfo(1,"after substitution, integrand is",f);
  repeat i:=intlib::tower(f) until i<>FALSE end_repeat;
  if i=FAIL then return(hold(int)(args())) end_if;
  userinfo(1,"field extension of rational numbers",Q,Q_sub);
  userinfo(1,"tower extension of functions",k,k_sub);
  userinfo(1,"after field extensions, integrand is",i);
  integral:=intlib::intt(i,n);
  if integral=FAIL then return(hold(int)(args())) end_if;
  userinfo(1,"integral is",integral);
  tosubs:=[k_sub[n-i]$hold(i)=0..n-2, Q_sub[nops(Q)-i]$hold(i)=0..nops(Q)-1];
  while has(integral,tosubs) do
     integral:=eval(subs(integral,k_sub[n-i]=k[n-i]$hold(i)=0..n-2,
                       Q_sub[nops(Q)-i]=Q[nops(Q)-i]$hold(i)=0..nops(Q)-1))
  end_while;
  if hasI=FALSE and has(integral,I) then # gets only the real part #
     n:=sign(x);
     sign(x):=1;
     i:=rectform(integral,{x});
     i:=expr(Re(i));
     if not has(i,{Re,Im}) then integral:=i end_if;
     sign(x):=(if type(n)<>"sign" then n end_if); # else NIL #
  end_if;
  if hassincos then integral:=combine(expand(intlib::to_sincos(integral,x)),sincos) end_if;
  return(integral);
end_proc:
