# $Date: 1994/10/03 22:53:46 $ $Author: kraume $ $Revision: 1.2 $ #
#--
intlib::pde_exp(A,B,C,n,m) - solves the polynomial differential equation 
AY'+BY=C when the degrees of A and B as polynomials in the last extension are 
zero and this extension is an exponential monomial.
It call's the procedure solve_Rde recursiv.
M. Bronstein, The Transcendental Risch Differential Equation, Journal of
Symbolic Computation, 1990, 9
--#
intlib::pde_exp:=proc(A,B,C,n,m)
  local c,y,i;
# global k_sub,k_diff; #
begin
#tt
  if test
    then print(Unquoted,"n=",n,
              "enter procedure pde_exp with",A,"Y'+",B,"Y=",C,"with bound m=",m)
  end_if;
  if (c:=degree(C))>m
    then _proof("can't solve the Rde:",A,B,C,n,"because the bound is to low");
  end_if;
tt#
  if (c:=degree(C))>m then return(FAIL); end_if;
  A:=expr(A); B:=expr(B);
  for i from c downto 0 do
    y[i]:=intlib::solveRde(i*k_diff[n]+B/A,coeff(C,i)/A,n-1);
#tt
    if y[i]=FAIL
      then _proof("can't solve the polynomial differential equation",A,B,C,n);
    end_if;
tt#
    if y[i]=FAIL then return(FAIL); end_if;
  end_for;
  return(_plus(y[i]*k_sub[n]^i $ hold(i)=0..c));
end_proc:
