# $Date: 1994/10/03 22:53:48 $ $Author: kraume $ $Revision: 1.2 $ #
#--
intlib::pde_var(A,B,C,n,m) - solves the polynomial differential equation 
AY'+BY=C when the degrees of A and B as polynomials in the last extension are 
zero and this extension is the integation variable.
It call's the procedure solve_Rde recursiv.
M. Bronstein, The Transcendental Risch Differential Equation, Journal of
Symbolic Computation, 1990, 9
--#
intlib::pde_var:=proc(A,B,C,m)
  local c,y,Y,i,x;
# global k_sub; #
begin
#tt
  if test
    then print(Unquoted,"n=",n,
              "enter procedure pde_var with",A,"Y'+",B,"Y=",C,"with bound m=",m)
  end_if;
  if (c:=degree(C))>m
    then _proof("can't solve the Rde:",A,B,C,n,"because the bound is to low");
  end_if;
tt#
  if (c:=degree(C))>m then return(FAIL); end_if;
  x:=k_sub[1]; A:=expr(A); B:=expr(B);
  y:=normal(lcoeff(C)/B);
  Y:=y*x^c;
  for i from c-1 downto 0 do
    y:=normal((coeff(C,i)-A*(i+1)*y)/B);
    Y:=Y+y*x^i;
  end_for;
  return(Y);
end_proc:
