# $Date: 1995/06/07 13:17:46 $ $Author: zimmerma $ $Revision: 1.5 $ #
#--
intlib::solveRde(f,g,n) -solves the 
Risch differential equation y'+fy=g for f,g in k[n]
M. Bronstein, The Transcendental Risch Differential Equation, Journal of
Symbolic Computation, 1990, 9
--#
intlib::solveRde:=proc(f,g,n)
  local P,G,T,A,B,C,x,b,c,r,t,Y;
# global k_sub,k_diff; #
begin
  userinfo(2,"n=",n,"solving Risch de Y'+(",f,")*Y=",g);
  x:=k_sub[n];
  P:=intlib::weaknorm(f,n);
  if P=FAIL then return(FAIL); end_if;
#tt
  if test
    then print(Unquoted,"n=",n,"P=",P);
  end_if;
tt#
  f:=intlib::split2(f-intlib::diffs(P,n)/P,n);
  g:=intlib::split2(P*g,n);
  G:=intlib::gcdk_n(f[4],g[4]);
  T:=intlib::sim(divide(intlib::gcdk_n(g[4],diff(g[4],x)),
                        intlib::gcdk_n(G,diff(G,x)))[1]);
#tt
  if test then print(Unquoted,"T=",T); end_if;
tt#
  G:=intlib::sim(divide(f[4]*T^2,g[4]));
#tt
  if not(iszero(G[2]))
    then intlib::_proof(Unquoted,
                      "can,t solve Risch de:Y'+(",args(1),")*Y=",args(2),"n=",n,
                      "because E dosen't divide DT^2");
  end_if;  
tt#
  if not(iszero(G[2])) then return(FAIL); end_if;  
  A:=intlib::sim(f[4]*T);
  B:=intlib::sim(f[1]*f[4]*T+(f[3]*T-f[4]*intlib::diffs(T,n))*f[2]);
  C:=intlib::sim(g[1]*f[4]*T^2+g[3]*G[1]*g[2]);
  if op(k[n],0)=hold(exp)
    then b:=degree(f[2])-degree(nthmonomial(B,nterms(B)));
         if iszero(C) then c:=0;
                      else c:=degree(g[2])-degree(nthmonomial(C,nterms(C)));
         end_if;
#tt
         if test then print(Unquoted,"n=",n,"b=",b,"c=",c); end_if;
tt#
         if b<>0
           then r:=min(0,max(0,b)-c);
           else r:=intlib::inttest(nthcoeff(B,nterms(B))/nthcoeff(A,nterms(A)),j
                                                                              );                  #tt
                if test
                  then print(Unquoted,"n=",n,"have to bring ",
                  intlib::intt(nthcoeff(B,nterms(B))/nthcoeff(A,nterms(A)),n-1),
                               "into the form c*(",op(k[n],1),")-ln(y)","c=",r);
                end_if;
tt#
                if r=FAIL then r:=min(0,-c); else r:=min(-r,-c); end_if;
         end_if;
         t:=max(0,b,r+c);
         A:=A*poly(x^t,[x]);
         B:=intlib::sim(multcoeffs(A,r*k_diff[n])+
                        B*poly(x^(t-degree(f[2])),[x]));
         C:=C*poly(x^(t-r-degree(g[2])),[x]);
    else r:=0;
  end_if;
#tt
  if test
    then print(Unquoted,"n=",n,
                        "have to solve polynomial de (",A,")*Y'+(",B,")*Y=",C);
  end_if;
tt#
  Y:=intlib::bound(A,B,C,n);
#tt
  if Y=FAIL
    then intlib::_proof(Unquoted,
                    "can't solve polynomial de:(",A,")*Y'+(",B,")*Y=",C,"n=",n);
  end_if;
  if test
    then print(Unquoted,"n=",n,"the solution is Y=",Y/(expr(T)*P)*x^r);
  end_if;
tt#
  if Y=FAIL then return(FAIL); end_if;
  return(Y/(expr(T)*P)*x^r);
end_proc:
