# $Date: 1994/10/03 22:54:01 $ $Author: kraume $ $Revision: 1.2 $ #
#--
intlib::split2(f,n) - computes the split factorization of the function f in the 
field extension k[n] and yields the canonical representation as the sequence
numerator and denominator of the special part and numerator and denominator of
the normal part.
M. Bronstein, A Unification of Liouvillian Extension, AAECC 1990, 1
--#
intlib::split2:=proc(f,n)
  local  P,S,N;
# global k_sub,k_deg; #
begin
  N:=poly(denom(f),[k_sub[n]]);
  P:=1/lcoeff(N);
  N:=intlib::sim(multcoeffs(N,P));
  f:=intlib::sim(multcoeffs(poly(numer(f),[k_sub[n]]),P));
  S:=poly(1,[k_sub[n]]);
  if degree(N)=0 then return(f,S,poly(0,[k_sub[n]]),S); end_if;
  if k_deg[n]=0  then f:=intlib::sim(divide(f,N));
                      return(f[1],S,f[2],N);
  end_if;
  while degree((P:=intlib::sim(divide(intlib::gcdk_n(N,intlib::diffs(N,n)),
                                  intlib::gcdk_n(N,diff(N,k_sub[n])))[1])))>0 do
    N:=intlib::sim(divide(N,P)[1]);
    S:=S*P;
  end_while;
  S:=intlib::sim(S);
# now S is the special part and N is the normal part of the denominator of f #
  P:=intlib::gcdex(S,N);
  n:=intlib::sim(divide(P[2]*f,N));
  return(intlib::sim(P[3]*f+n[1]*S),S,n[2],N);
end_proc:
